/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.diffuser;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.CapabilityRuneHandler;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.container.IContainerTopBlockEntity;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.config.ECConfig;

public class DiffuserBlockEntity
extends AbstractECBlockEntity
implements IContainerTopBlockEntity {
    @ObjectHolder(value="elementalcraft:diffuser")
    public static final BlockEntityType<DiffuserBlockEntity> TYPE = null;
    private boolean hasDiffused;
    private final RuneHandler runeHandler;

    public DiffuserBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.diffuserMaxRunes.get(), this::m_6596_);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.hasDiffused = compound.m_128471_("has_diffused");
        if (compound.m_128441_("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.m_128437_("rune_handler", 8));
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("has_diffused", this.hasDiffused);
        compound.m_128365_("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DiffuserBlockEntity diffuser) {
        ISingleElementStorage tank = diffuser.getContainer();
        AtomicInteger amount = new AtomicInteger((Integer)ECConfig.COMMON.diffuserDiffusionAmount.get());
        diffuser.hasDiffused = false;
        if (tank != null && !tank.isEmpty()) {
            diffuser.m_58904_().m_45933_(null, new AABB(diffuser.m_58899_()).m_82400_((double)((Integer)ECConfig.COMMON.diffuserRange.get()).intValue())).stream().map(CapabilityElementStorage::get).map(LazyOptional::resolve).filter(Optional::isPresent).map(Optional::get).forEach(storage -> {
                if (!tank.isEmpty() && amount.get() > 0) {
                    amount.set(diffuser.runeHandler.handleElementTransfer(tank, (IElementStorage)storage, amount.get()));
                    diffuser.hasDiffused = true;
                }
            });
        }
    }

    public boolean hasDiffused() {
        return this.hasDiffused;
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityRuneHandler.RUNE_HANDLE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
        }
        return super.getCapability(cap, side);
    }
}

