/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container.reservoir;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.block.container.AbstractConnectedElementContainerBlock;
import sirttas.elementalcraft.block.container.reservoir.ReservoirBlockEntity;
import sirttas.elementalcraft.block.shrine.AbstractPylonShrineBlock;
import sirttas.elementalcraft.config.ECConfig;

public class ReservoirBlock
extends AbstractConnectedElementContainerBlock
implements IElementTypeProvider {
    public static final String NAME = "reservoir";
    public static final String NAME_FIRE = "reservoir_fire";
    public static final String NAME_WATER = "reservoir_water";
    public static final String NAME_EARTH = "reservoir_earth";
    public static final String NAME_AIR = "reservoir_air";
    private static final VoxelShape UPPER_GLASS = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    private static final VoxelShape UPPER_PIPE_1 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)3.0);
    private static final VoxelShape UPPER_PIPE_2 = Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0);
    private static final VoxelShape UPPER_PIPE_3 = Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)15.0);
    private static final VoxelShape UPPER_PIPE_4 = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape UPPER_CONNECTOR = Block.m_49796_((double)6.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape UPPER_SHAPE = Shapes.m_83124_((VoxelShape)UPPER_GLASS, (VoxelShape[])new VoxelShape[]{UPPER_PIPE_1, UPPER_PIPE_2, UPPER_PIPE_3, UPPER_PIPE_4, UPPER_CONNECTOR});
    private static final VoxelShape LOWER_GLASS_1 = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape LOWER_GLASS_2 = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private static final VoxelShape LOWER_PIPE_1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0);
    private static final VoxelShape LOWER_PIPE_2 = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    private static final VoxelShape LOWER_PIPE_3 = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0);
    private static final VoxelShape LOWER_PIPE_4 = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape LOWER_WALL_NORTH = Block.m_49796_((double)4.0, (double)2.0, (double)1.0, (double)12.0, (double)9.0, (double)3.0);
    private static final VoxelShape LOWER_WALL_SOUTH = Block.m_49796_((double)4.0, (double)2.0, (double)13.0, (double)12.0, (double)9.0, (double)15.0);
    private static final VoxelShape LOWER_WALL_WEST = Block.m_49796_((double)1.0, (double)2.0, (double)4.0, (double)3.0, (double)9.0, (double)12.0);
    private static final VoxelShape LOWER_WALL_EAST = Block.m_49796_((double)13.0, (double)2.0, (double)4.0, (double)15.0, (double)9.0, (double)12.0);
    private static final VoxelShape LOWER_PLATE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape LOWER_BASE = Shapes.m_83124_((VoxelShape)LOWER_GLASS_1, (VoxelShape[])new VoxelShape[]{LOWER_GLASS_2, LOWER_PIPE_1, LOWER_PIPE_2, LOWER_PIPE_3, LOWER_PIPE_4, LOWER_WALL_NORTH, LOWER_WALL_SOUTH, LOWER_WALL_WEST, LOWER_WALL_EAST, LOWER_PLATE});
    private static final VoxelShape EARTH_WALL_NORTH = Block.m_49796_((double)4.0, (double)9.0, (double)1.0, (double)12.0, (double)14.0, (double)3.0);
    private static final VoxelShape EARTH_WALL_SOUTH = Block.m_49796_((double)4.0, (double)9.0, (double)13.0, (double)12.0, (double)14.0, (double)15.0);
    private static final VoxelShape EARTH_WALL_WEST = Block.m_49796_((double)1.0, (double)9.0, (double)4.0, (double)3.0, (double)14.0, (double)12.0);
    private static final VoxelShape EARTH_WALL_EAST = Block.m_49796_((double)13.0, (double)9.0, (double)4.0, (double)15.0, (double)14.0, (double)12.0);
    private static final VoxelShape LOWER_EARTH = Shapes.m_83124_((VoxelShape)LOWER_BASE, (VoxelShape[])new VoxelShape[]{EARTH_WALL_NORTH, EARTH_WALL_SOUTH, EARTH_WALL_WEST, EARTH_WALL_EAST});
    private static final VoxelShape AIR_PIPE_1 = Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)3.0, (double)16.0, (double)3.0);
    private static final VoxelShape AIR_PIPE_2 = Block.m_49796_((double)13.0, (double)5.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0);
    private static final VoxelShape AIR_PIPE_3 = Block.m_49796_((double)1.0, (double)5.0, (double)13.0, (double)3.0, (double)16.0, (double)15.0);
    private static final VoxelShape AIR_PIPE_4 = Block.m_49796_((double)13.0, (double)5.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape AIR_PLATE = Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape AIR_PLATE_2 = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0);
    private static final VoxelShape LOWER_AIR = Shapes.m_83124_((VoxelShape)LOWER_GLASS_1, (VoxelShape[])new VoxelShape[]{AIR_PIPE_1, AIR_PIPE_2, AIR_PIPE_3, AIR_PIPE_4, AIR_PLATE, AIR_PLATE_2});
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private final ElementType elementType;

    public ReservoirBlock(ElementType elementType) {
        this.elementType = elementType;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new ReservoirBlockEntity(pos, state);
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    public void m_6402_(Level worldIn, BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        worldIn.m_7731_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        AbstractPylonShrineBlock.doubleHalfHarvest((Block)this, level, pos, state, player);
        super.m_5707_(level, pos, state, player);
    }

    @Override
    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        VoxelShape shape;
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            shape = UPPER_SHAPE;
        } else {
            shape = switch (this.getElementType()) {
                case ElementType.AIR -> LOWER_AIR;
                case ElementType.EARTH -> LOWER_EARTH;
                default -> LOWER_BASE;
            };
        }
        return Shapes.m_83110_((VoxelShape)shape, (VoxelShape)super.m_5940_(state, level, pos, context));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> container) {
        container.m_61104_(new Property[]{HALF, NORTH, SOUTH, EAST, WEST});
    }

    @Override
    protected int getDefaultCapacity() {
        return (Integer)ECConfig.COMMON.reservoirCapacity.get();
    }

    @Override
    public void m_49811_(@Nonnull CreativeModeTab group, NonNullList<ItemStack> items) {
        ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
        CompoundTag tag = stack.m_41698_("BlockEntityTag");
        tag.m_128365_("element_storage", (Tag)new SingleElementStorage(this.getElementType(), this.getDefaultCapacity(), this.getDefaultCapacity()).serializeNBT());
        items.add((Object)new ItemStack((ItemLike)this.m_5456_()));
        items.add((Object)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            super.m_7100_(state, level, pos, rand);
        }
    }
}

