/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.container;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.block.container.IElementContainer;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;

public abstract class AbstractElementContainerBlockEntity
extends AbstractECBlockEntity
implements IElementContainer {
    protected final SingleElementStorage elementStorage;

    protected AbstractElementContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, Function<Runnable, SingleElementStorage> elementStorage) {
        super(blockEntityType, pos, state);
        this.elementStorage = elementStorage.apply(this::m_6596_);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("element_storage")) {
            this.elementStorage.deserializeNBT(compound.m_128469_("element_storage"));
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("element_storage", (Tag)this.elementStorage.serializeNBT());
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY) {
            return LazyOptional.of((NonNullSupplier)(this.elementStorage != null ? () -> this.elementStorage : null)).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }
}

