/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.Type;
import java.util.Arrays;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.CrystalOreBlock;
import sirttas.elementalcraft.block.ITooltipImageBlock;
import sirttas.elementalcraft.block.container.AbstractElementContainerBlock;
import sirttas.elementalcraft.block.container.ElementContainerBlock;
import sirttas.elementalcraft.block.container.ElementContainerBlockEntity;
import sirttas.elementalcraft.block.container.ElementContainerBlockItem;
import sirttas.elementalcraft.block.container.SmallElementContainerBlock;
import sirttas.elementalcraft.block.container.creative.CreativeElementContainerBlock;
import sirttas.elementalcraft.block.container.creative.CreativeElementContainerBlockEntity;
import sirttas.elementalcraft.block.container.reservoir.ReservoirBlock;
import sirttas.elementalcraft.block.container.reservoir.ReservoirBlockEntity;
import sirttas.elementalcraft.block.diffuser.DiffuserBlock;
import sirttas.elementalcraft.block.diffuser.DiffuserBlockEntity;
import sirttas.elementalcraft.block.evaporator.EvaporatorBlock;
import sirttas.elementalcraft.block.evaporator.EvaporatorBlockEntity;
import sirttas.elementalcraft.block.extractor.ExtractorBlock;
import sirttas.elementalcraft.block.extractor.ExtractorBlockEntity;
import sirttas.elementalcraft.block.extractor.improved.ImprovedExtractorBlock;
import sirttas.elementalcraft.block.instrument.binder.BinderBlock;
import sirttas.elementalcraft.block.instrument.binder.BinderBlockEntity;
import sirttas.elementalcraft.block.instrument.binder.improved.ImprovedBinderBlock;
import sirttas.elementalcraft.block.instrument.binder.improved.ImprovedBinderBlockEntity;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerBlock;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerBlockEntity;
import sirttas.elementalcraft.block.instrument.infuser.InfuserBlock;
import sirttas.elementalcraft.block.instrument.infuser.InfuserBlockEntity;
import sirttas.elementalcraft.block.instrument.inscriber.InscriberBlock;
import sirttas.elementalcraft.block.instrument.inscriber.InscriberBlockEntity;
import sirttas.elementalcraft.block.instrument.io.firefurnace.FireFurnaceBlock;
import sirttas.elementalcraft.block.instrument.io.firefurnace.FireFurnaceBlockEntity;
import sirttas.elementalcraft.block.instrument.io.firefurnace.blast.FireBlastFurnaceBlock;
import sirttas.elementalcraft.block.instrument.io.firefurnace.blast.FireBlastFurnaceBlockEntity;
import sirttas.elementalcraft.block.instrument.io.mill.AirMillBlock;
import sirttas.elementalcraft.block.instrument.io.mill.AirMillBlockEntity;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierBlock;
import sirttas.elementalcraft.block.instrument.io.purifier.PurifierBlockEntity;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserBlock;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserBlockEntity;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlock;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlockEntity;
import sirttas.elementalcraft.block.retriever.RetrieverBlock;
import sirttas.elementalcraft.block.shrine.breeding.BreedingShrineBlock;
import sirttas.elementalcraft.block.shrine.breeding.BreedingShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlock;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.enderlock.EnderLockShrineBlock;
import sirttas.elementalcraft.block.shrine.enderlock.EnderLockShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.firepylon.FirePylonBlock;
import sirttas.elementalcraft.block.shrine.firepylon.FirePylonBlockEntity;
import sirttas.elementalcraft.block.shrine.grove.GroveShrineBlock;
import sirttas.elementalcraft.block.shrine.grove.GroveShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.growth.GrowthShrineBlock;
import sirttas.elementalcraft.block.shrine.growth.GrowthShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.harvest.HarvestShrineBlock;
import sirttas.elementalcraft.block.shrine.harvest.HarvestShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.lava.LavaShrineBlock;
import sirttas.elementalcraft.block.shrine.lava.LavaShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.ore.OreShrineBlock;
import sirttas.elementalcraft.block.shrine.ore.OreShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.overload.OverloadShrineBlock;
import sirttas.elementalcraft.block.shrine.overload.OverloadShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.spawning.SpawningShrineBlock;
import sirttas.elementalcraft.block.shrine.spawning.SpawningShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.spring.SpringShrineBlock;
import sirttas.elementalcraft.block.shrine.spring.SpringShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.sweet.SweetShrineBlock;
import sirttas.elementalcraft.block.shrine.sweet.SweetShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.directional.CapacityShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.EfficiencyShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.OptimizationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.RangeShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.StrengthShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.acceleration.AccelerationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.directional.acceleration.AccelerationShrineUpgradeBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.CrystalHarvestShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.FortuneShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.NectarShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.ProtectionShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.SilkTouchShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.SpringalineShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.BonelessGrowthShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.FillingShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.MysticalGroveShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.PickupShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.PlantingShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.StemPollinationShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.vortex.VortexShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.unidirectional.vortex.VortexShrineUpgradeBlockEntity;
import sirttas.elementalcraft.block.shrine.vacuum.VacuumShrineBlock;
import sirttas.elementalcraft.block.shrine.vacuum.VacuumShrineBlockEntity;
import sirttas.elementalcraft.block.sorter.SorterBlock;
import sirttas.elementalcraft.block.sorter.SorterBlockEntity;
import sirttas.elementalcraft.block.source.SourceBlock;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.block.spelldesk.SpellDeskBlock;
import sirttas.elementalcraft.block.synthesizer.mana.ManaSynthesizerBlock;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerBlock;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerBlockEntity;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.interaction.ECinteractions;
import sirttas.elementalcraft.interaction.botania.BotaniaInteractions;
import sirttas.elementalcraft.item.TooltipImageBlockItem;
import sirttas.elementalcraft.property.ECProperties;
import sirttas.elementalcraft.registry.RegistryHelper;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECBlocks {
    public static final BlockBehaviour.StatePredicate ALWAYS_FALSE = (a, b, c) -> false;
    public static final RegistryObject<Block> SMALL_CONTAINER = ECBlocks.object("small_container");
    public static final RegistryObject<Block> CONTAINER = ECBlocks.object("container");
    @ObjectHolder(value="elementalcraft:reservoir_fire")
    public static final ReservoirBlock FIRE_RESERVOIR = null;
    @ObjectHolder(value="elementalcraft:reservoir_water")
    public static final ReservoirBlock WATER_RESERVOIR = null;
    @ObjectHolder(value="elementalcraft:reservoir_earth")
    public static final ReservoirBlock EARTH_RESERVOIR = null;
    @ObjectHolder(value="elementalcraft:reservoir_air")
    public static final ReservoirBlock AIR_RESERVOIR = null;
    @ObjectHolder(value="elementalcraft:creative_container")
    public static final CreativeElementContainerBlock CREATIVE_CONTAINER = null;
    @ObjectHolder(value="elementalcraft:extractor")
    public static final ExtractorBlock EXTRACTOR = null;
    @ObjectHolder(value="elementalcraft:extractor_improved")
    public static final ImprovedExtractorBlock EXTRACTOR_IMPROVED = null;
    @ObjectHolder(value="elementalcraft:evaporator")
    public static final EvaporatorBlock EVAPORATOR = null;
    @ObjectHolder(value="elementalcraft:solar_synthesizer")
    public static final SolarSynthesizerBlock SOLAR_SYNTHESIZER = null;
    @ObjectHolder(value="elementalcraft:mana_synthesizer")
    public static final ManaSynthesizerBlock MANA_SYNTHESIZER = null;
    @ObjectHolder(value="elementalcraft:diffuser")
    public static final DiffuserBlock DIFFUSER = null;
    @ObjectHolder(value="elementalcraft:infuser")
    public static final InfuserBlock INFUSER = null;
    @ObjectHolder(value="elementalcraft:binder")
    public static final BinderBlock BINDER = null;
    @ObjectHolder(value="elementalcraft:binder_improved")
    public static final ImprovedBinderBlock BINDER_IMPROVED = null;
    @ObjectHolder(value="elementalcraft:crystallizer")
    public static final CrystallizerBlock CRYSTALLIZER = null;
    @ObjectHolder(value="elementalcraft:inscriber")
    public static final InscriberBlock INSCRIBER = null;
    @ObjectHolder(value="elementalcraft:air_mill")
    public static final AirMillBlock AIR_MILL = null;
    @ObjectHolder(value="elementalcraft:pedestal_fire")
    public static final PedestalBlock FIRE_PEDESTAL = null;
    @ObjectHolder(value="elementalcraft:pedestal_water")
    public static final PedestalBlock WATER_PEDESTAL = null;
    @ObjectHolder(value="elementalcraft:pedestal_earth")
    public static final PedestalBlock EARTH_PEDESTAL = null;
    @ObjectHolder(value="elementalcraft:pedestal_air")
    public static final PedestalBlock AIR_PEDESTAL = null;
    @ObjectHolder(value="elementalcraft:pureinfuser")
    public static final PureInfuserBlock PURE_INFUSER = null;
    @ObjectHolder(value="elementalcraft:firefurnace")
    public static final FireFurnaceBlock FIRE_FURNACE = null;
    @ObjectHolder(value="elementalcraft:fireblastfurnace")
    public static final FireBlastFurnaceBlock FIRE_BLAST_FURNACE = null;
    @ObjectHolder(value="elementalcraft:purifier")
    public static final PurifierBlock PURIFIER = null;
    @ObjectHolder(value="elementalcraft:elementpipe_impaired")
    public static final ElementPipeBlock PIPE_IMPAIRED = null;
    @ObjectHolder(value="elementalcraft:elementpipe")
    public static final ElementPipeBlock PIPE = null;
    @ObjectHolder(value="elementalcraft:elementpipe_improved")
    public static final ElementPipeBlock PIPE_IMPROVED = null;
    @ObjectHolder(value="elementalcraft:instrument_retriever")
    public static final RetrieverBlock RETRIEVER = null;
    @ObjectHolder(value="elementalcraft:sorter")
    public static final SorterBlock SORTER = null;
    @ObjectHolder(value="elementalcraft:spell_desk")
    public static final SpellDeskBlock SPELL_DESK = null;
    @ObjectHolder(value="elementalcraft:firepylon")
    public static final FirePylonBlock FIRE_PYLON = null;
    @ObjectHolder(value="elementalcraft:vacuumshrine")
    public static final VacuumShrineBlock VACUUM_SHRINE = null;
    @ObjectHolder(value="elementalcraft:growthshrine")
    public static final GrowthShrineBlock GROWTH_SHRINE = null;
    @ObjectHolder(value="elementalcraft:harvestshrine")
    public static final HarvestShrineBlock HARVEST_SHRINE = null;
    @ObjectHolder(value="elementalcraft:lavashrine")
    public static final LavaShrineBlock LAVA_SHRINE = null;
    @ObjectHolder(value="elementalcraft:oreshrine")
    public static final OreShrineBlock ORE_SHRINE = null;
    @ObjectHolder(value="elementalcraft:overloadshrine")
    public static final OverloadShrineBlock OVERLOAD_SHRINE = null;
    @ObjectHolder(value="elementalcraft:sweetshrine")
    public static final SweetShrineBlock SWEET_SHRINE = null;
    @ObjectHolder(value="elementalcraft:enderlockshrine")
    public static final EnderLockShrineBlock ENDER_LOCK_SHRINE = null;
    @ObjectHolder(value="elementalcraft:breedingshrine")
    public static final BreedingShrineBlock BREEDING_SHRINE = null;
    @ObjectHolder(value="elementalcraft:groveshrine")
    public static final GroveShrineBlock GROVE_SHRINE = null;
    @ObjectHolder(value="elementalcraft:springshrine")
    public static final SpringShrineBlock SPRING_SHRINE = null;
    @ObjectHolder(value="elementalcraft:buddingshrine")
    public static final BuddingShrineBlock BUDDING_SHRINE = null;
    @ObjectHolder(value="elementalcraft:spawningshrine")
    public static final SpawningShrineBlock SPAWNING_SHRINE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_acceleration")
    public static final AccelerationShrineUpgradeBlock ACCELERATION_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_range")
    public static final RangeShrineUpgradeBlock RANGE_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_capacity")
    public static final CapacityShrineUpgradeBlock CAPACITY_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_efficiency")
    public static final EfficiencyShrineUpgradeBlock EFFICIENCY_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_strength")
    public static final StrengthShrineUpgradeBlock STRENGTH_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_optimization")
    public static final OptimizationShrineUpgradeBlock OPTIMIZATION_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_fortune")
    public static final FortuneShrineUpgradeBlock FORTUNE_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_silk_touch")
    public static final SilkTouchShrineUpgradeBlock SILK_TOUCH_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_planting")
    public static final PlantingShrineUpgradeBlock PLANTING_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_boneless_growth")
    public static final BonelessGrowthShrineUpgradeBlock BONELESS_GROWTH_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_pickup")
    public static final PickupShrineUpgradeBlock PICKUP_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_vortex")
    public static final VortexShrineUpgradeBlock VORTEX_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_nectar")
    public static final NectarShrineUpgradeBlock NECTAR_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_mystical_grove")
    public static final MysticalGroveShrineUpgradeBlock MYSTICAL_GROVE_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_stem_pollination")
    public static final StemPollinationShrineUpgradeBlock STEM_POLLINATION_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_protection")
    public static final ProtectionShrineUpgradeBlock PROTECTION_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_filling")
    public static final FillingShrineUpgradeBlock FILLING_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_springaline")
    public static final SpringalineShrineUpgradeBlock SPRINGALINE_SHRINE_UPGRADE = null;
    @ObjectHolder(value="elementalcraft:shrine_upgrade_crystal_harvest")
    public static final CrystalHarvestShrineUpgradeBlock CRYSTAL_HARVEST_SHRINE_UPGRADE = null;
    public static final RegistryObject<Block> SOURCE = ECBlocks.object("source");
    public static final RegistryObject<Block> CRYSTAL_ORE = ECBlocks.object("inert_crystal_ore");
    public static final RegistryObject<Block> DEEPSLATE_CRYSTAL_ORE = ECBlocks.object("deepslate_inert_crystal_ore");
    public static final RegistryObject<Block> WHITE_ROCK = ECBlocks.object("whiterock");
    @ObjectHolder(value="elementalcraft:whiterock_slab")
    public static final SlabBlock WHITE_ROCK_SLAB = null;
    @ObjectHolder(value="elementalcraft:whiterock_stairs")
    public static final StairBlock WHITE_ROCK_STAIRS = null;
    @ObjectHolder(value="elementalcraft:whiterock_wall")
    public static final WallBlock WHITE_ROCK_WALL = null;
    @ObjectHolder(value="elementalcraft:whiterock_fence")
    public static final FenceBlock WHITE_ROCK_FENCE = null;
    public static final RegistryObject<Block> WHITE_ROCK_BRICK = ECBlocks.object("whiterock_brick");
    @ObjectHolder(value="elementalcraft:whiterock_brick_slab")
    public static final SlabBlock WHITE_ROCK_BRICK_SLAB = null;
    @ObjectHolder(value="elementalcraft:whiterock_brick_stairs")
    public static final StairBlock WHITE_ROCK_BRICK_STAIRS = null;
    @ObjectHolder(value="elementalcraft:whiterock_brick_wall")
    public static final WallBlock WHITE_ROCK_BRICK_WALL = null;
    public static final RegistryObject<Block> PURE_ROCK = ECBlocks.object("purerock");
    @ObjectHolder(value="elementalcraft:purerock_slab")
    public static final SlabBlock PURE_ROCK_SLAB = null;
    @ObjectHolder(value="elementalcraft:purerock_stairs")
    public static final StairBlock PURE_ROCK_STAIRS = null;
    @ObjectHolder(value="elementalcraft:purerock_wall")
    public static final WallBlock PURE_ROCK_WALL = null;
    @ObjectHolder(value="elementalcraft:burnt_glass")
    public static final GlassBlock BURNT_GLASS = null;
    @ObjectHolder(value="elementalcraft:burnt_glass_pane")
    public static final IronBarsBlock BURNT_GLASS_PANE = null;
    @ObjectHolder(value="elementalcraft:drenched_iron_block")
    public static final Block DRENCHED_IRON_BLOCK = null;
    @ObjectHolder(value="elementalcraft:swift_alloy_block")
    public static final Block SWIFT_ALLOY_BLOCK = null;
    public static final RegistryObject<Block> FIREITE_BLOCK = ECBlocks.object("fireite_block");
    @ObjectHolder(value="elementalcraft:inertcrystal_block")
    public static final Block INERT_CRYSTAL_BLOCK = null;
    @ObjectHolder(value="elementalcraft:firecrystal_block")
    public static final Block FIRE_CRYSTAL_BLOCK = null;
    @ObjectHolder(value="elementalcraft:watercrystal_block")
    public static final Block WATER_CRYSTAL_BLOCK = null;
    @ObjectHolder(value="elementalcraft:earthcrystal_block")
    public static final Block EARTH_CRYSTAL_BLOCK = null;
    @ObjectHolder(value="elementalcraft:aircrystal_block")
    public static final Block AIR_CRYSTAL_BLOCK = null;
    @ObjectHolder(value="elementalcraft:springaline_block")
    public static final Block SPRINGALINE_BLOCK = null;
    @ObjectHolder(value="elementalcraft:springaline_cluster")
    public static final Block SPRINGALINE_CLUSTER = null;
    @ObjectHolder(value="elementalcraft:large_springaline_bud")
    public static final Block LARGE_SPRINGALINE_BUD = null;
    @ObjectHolder(value="elementalcraft:medium_springaline_bud")
    public static final Block MEDIUM_SPRINGALINE_BUD = null;
    @ObjectHolder(value="elementalcraft:small_springaline_bud")
    public static final Block SMALL_SPRINGALINE_BUD = null;
    @ObjectHolder(value="elementalcraft:springaline_glass")
    public static final Block SPRINGALINE_GLASS = null;
    @ObjectHolder(value="elementalcraft:springaline_glass_pane")
    public static final Block SPRINGALINE_GLASS_PANE = null;

    private ECBlocks() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        RegistryHelper.register(registry, new SmallElementContainerBlock(), SMALL_CONTAINER);
        RegistryHelper.register(registry, new ElementContainerBlock(), "container");
        RegistryHelper.register(registry, new ReservoirBlock(ElementType.FIRE), "reservoir_fire");
        RegistryHelper.register(registry, new ReservoirBlock(ElementType.WATER), "reservoir_water");
        RegistryHelper.register(registry, new ReservoirBlock(ElementType.EARTH), "reservoir_earth");
        RegistryHelper.register(registry, new ReservoirBlock(ElementType.AIR), "reservoir_air");
        RegistryHelper.register(registry, new CreativeElementContainerBlock(), "creative_container");
        RegistryHelper.register(registry, new ExtractorBlock(), "extractor");
        RegistryHelper.register(registry, new ImprovedExtractorBlock(), "extractor_improved");
        RegistryHelper.register(registry, new EvaporatorBlock(), "evaporator");
        RegistryHelper.register(registry, new SolarSynthesizerBlock(), "solar_synthesizer");
        RegistryHelper.register(registry, new ManaSynthesizerBlock(), "mana_synthesizer");
        RegistryHelper.register(registry, new DiffuserBlock(), "diffuser");
        RegistryHelper.register(registry, new InfuserBlock(), "infuser");
        RegistryHelper.register(registry, new BinderBlock(), "binder");
        RegistryHelper.register(registry, new ImprovedBinderBlock(), "binder_improved");
        RegistryHelper.register(registry, new CrystallizerBlock(), "crystallizer");
        RegistryHelper.register(registry, new InscriberBlock(), "inscriber");
        RegistryHelper.register(registry, new AirMillBlock(), "air_mill");
        RegistryHelper.register(registry, new PedestalBlock(ElementType.FIRE), "pedestal_fire");
        RegistryHelper.register(registry, new PedestalBlock(ElementType.WATER), "pedestal_water");
        RegistryHelper.register(registry, new PedestalBlock(ElementType.EARTH), "pedestal_earth");
        RegistryHelper.register(registry, new PedestalBlock(ElementType.AIR), "pedestal_air");
        RegistryHelper.register(registry, new PureInfuserBlock(), "pureinfuser");
        RegistryHelper.register(registry, new FireFurnaceBlock(), "firefurnace");
        RegistryHelper.register(registry, new FireBlastFurnaceBlock(), "fireblastfurnace");
        RegistryHelper.register(registry, new PurifierBlock(), "purifier");
        RegistryHelper.register(registry, new ElementPipeBlock((Integer)ECConfig.COMMON.impairedPipeTransferAmount.get()), "elementpipe_impaired");
        RegistryHelper.register(registry, new ElementPipeBlock((Integer)ECConfig.COMMON.pipeTransferAmount.get()), "elementpipe");
        RegistryHelper.register(registry, new ElementPipeBlock((Integer)ECConfig.COMMON.improvedPipeTransferAmount.get()), "elementpipe_improved");
        RegistryHelper.register(registry, new RetrieverBlock(), "instrument_retriever");
        RegistryHelper.register(registry, new SorterBlock(), "sorter");
        RegistryHelper.register(registry, new SpellDeskBlock(), "spell_desk");
        RegistryHelper.register(registry, new FirePylonBlock(), "firepylon");
        RegistryHelper.register(registry, new VacuumShrineBlock(), "vacuumshrine");
        RegistryHelper.register(registry, new GrowthShrineBlock(), "growthshrine");
        RegistryHelper.register(registry, new HarvestShrineBlock(), "harvestshrine");
        RegistryHelper.register(registry, new LavaShrineBlock(), "lavashrine");
        RegistryHelper.register(registry, new OreShrineBlock(), "oreshrine");
        RegistryHelper.register(registry, new OverloadShrineBlock(), "overloadshrine");
        RegistryHelper.register(registry, new SweetShrineBlock(), "sweetshrine");
        RegistryHelper.register(registry, new EnderLockShrineBlock(), "enderlockshrine");
        RegistryHelper.register(registry, new BreedingShrineBlock(), "breedingshrine");
        RegistryHelper.register(registry, new GroveShrineBlock(), "groveshrine");
        RegistryHelper.register(registry, new SpringShrineBlock(), "springshrine");
        RegistryHelper.register(registry, new BuddingShrineBlock(), "buddingshrine");
        RegistryHelper.register(registry, new SpawningShrineBlock(), "spawningshrine");
        RegistryHelper.register(registry, new AccelerationShrineUpgradeBlock(), "shrine_upgrade_acceleration");
        RegistryHelper.register(registry, new RangeShrineUpgradeBlock(), "shrine_upgrade_range");
        RegistryHelper.register(registry, new CapacityShrineUpgradeBlock(), "shrine_upgrade_capacity");
        RegistryHelper.register(registry, new EfficiencyShrineUpgradeBlock(), "shrine_upgrade_efficiency");
        RegistryHelper.register(registry, new StrengthShrineUpgradeBlock(), "shrine_upgrade_strength");
        RegistryHelper.register(registry, new OptimizationShrineUpgradeBlock(), "shrine_upgrade_optimization");
        RegistryHelper.register(registry, new FortuneShrineUpgradeBlock(), "shrine_upgrade_fortune");
        RegistryHelper.register(registry, new SilkTouchShrineUpgradeBlock(), "shrine_upgrade_silk_touch");
        RegistryHelper.register(registry, new PlantingShrineUpgradeBlock(), "shrine_upgrade_planting");
        RegistryHelper.register(registry, new BonelessGrowthShrineUpgradeBlock(), "shrine_upgrade_boneless_growth");
        RegistryHelper.register(registry, new PickupShrineUpgradeBlock(), "shrine_upgrade_pickup");
        RegistryHelper.register(registry, new VortexShrineUpgradeBlock(), "shrine_upgrade_vortex");
        RegistryHelper.register(registry, new NectarShrineUpgradeBlock(), "shrine_upgrade_nectar");
        RegistryHelper.register(registry, new StemPollinationShrineUpgradeBlock(), "shrine_upgrade_stem_pollination");
        RegistryHelper.register(registry, new ProtectionShrineUpgradeBlock(), "shrine_upgrade_protection");
        RegistryHelper.register(registry, new FillingShrineUpgradeBlock(), "shrine_upgrade_filling");
        RegistryHelper.register(registry, new SpringalineShrineUpgradeBlock(), "shrine_upgrade_springaline");
        RegistryHelper.register(registry, new CrystalHarvestShrineUpgradeBlock(), "shrine_upgrade_crystal_harvest");
        RegistryHelper.register(registry, new MysticalGroveShrineUpgradeBlock(), "shrine_upgrade_mystical_grove");
        RegistryHelper.register(registry, new SourceBlock(), SOURCE);
        RegistryHelper.register(registry, new CrystalOreBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(3.0f, 3.0f)), CRYSTAL_ORE);
        RegistryHelper.register(registry, new CrystalOreBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_155949_(MaterialColor.f_164534_).m_60913_(4.5f, 3.0f).m_60918_(SoundType.f_154677_)), DEEPSLATE_CRYSTAL_ORE);
        RegistryHelper.register(registry, new Block(ECProperties.Blocks.WHITEROCK), WHITE_ROCK);
        RegistryHelper.register(registry, new SlabBlock(ECProperties.Blocks.WHITEROCK), "whiterock_slab");
        RegistryHelper.register(registry, new StairBlock(() -> ((Block)WHITE_ROCK.get()).m_49966_(), ECProperties.Blocks.WHITEROCK), "whiterock_stairs");
        RegistryHelper.register(registry, new WallBlock(ECProperties.Blocks.WHITEROCK), "whiterock_wall");
        RegistryHelper.register(registry, new FenceBlock(ECProperties.Blocks.WHITEROCK), "whiterock_fence");
        RegistryHelper.register(registry, new Block(ECProperties.Blocks.WHITEROCK), WHITE_ROCK_BRICK);
        RegistryHelper.register(registry, new SlabBlock(ECProperties.Blocks.WHITEROCK), "whiterock_brick_slab");
        RegistryHelper.register(registry, new StairBlock(() -> ((Block)WHITE_ROCK_BRICK.get()).m_49966_(), ECProperties.Blocks.WHITEROCK), "whiterock_brick_stairs");
        RegistryHelper.register(registry, new WallBlock(ECProperties.Blocks.WHITEROCK), "whiterock_brick_wall");
        RegistryHelper.register(registry, new Block(ECProperties.Blocks.PUREROCK), PURE_ROCK);
        RegistryHelper.register(registry, new SlabBlock(ECProperties.Blocks.PUREROCK), "purerock_slab");
        RegistryHelper.register(registry, new StairBlock(() -> ((Block)PURE_ROCK.get()).m_49966_(), ECProperties.Blocks.PUREROCK), "purerock_stairs");
        RegistryHelper.register(registry, new WallBlock(ECProperties.Blocks.PUREROCK), "purerock_wall");
        RegistryHelper.register(registry, new GlassBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(0.7f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_((a, b, c, d) -> false).m_60924_(ALWAYS_FALSE).m_60960_(ALWAYS_FALSE).m_60971_(ALWAYS_FALSE)), "burnt_glass");
        RegistryHelper.register(registry, new IronBarsBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(0.7f).m_60918_(SoundType.f_56744_).m_60955_()), "burnt_glass_pane");
        RegistryHelper.register(registry, new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_)), "drenched_iron_block");
        RegistryHelper.register(registry, new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76366_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)), "swift_alloy_block");
        RegistryHelper.register(registry, new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76365_).m_60999_().m_60913_(50.0f, 1200.0f).m_60918_(SoundType.f_56725_)), FIREITE_BLOCK);
        RegistryHelper.register(registry, new Block(ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES), "inertcrystal_block");
        RegistryHelper.register(registry, new Block(ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES), "firecrystal_block");
        RegistryHelper.register(registry, new Block(ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES), "watercrystal_block");
        RegistryHelper.register(registry, new Block(ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES), "earthcrystal_block");
        RegistryHelper.register(registry, new Block(ECProperties.Blocks.DEFAULT_BLOCK_PROPERTIES), "aircrystal_block");
        RegistryHelper.register(registry, new AmethystBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_)), "springaline_block");
        RegistryHelper.register(registry, new AmethystClusterBlock(7, 3, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152492_)), "springaline_cluster");
        RegistryHelper.register(registry, new AmethystClusterBlock(5, 3, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152492_).m_60918_(SoundType.f_154657_).m_60953_(s -> 4)), "large_springaline_bud");
        RegistryHelper.register(registry, new AmethystClusterBlock(4, 3, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152492_).m_60918_(SoundType.f_154658_).m_60953_(s -> 2)), "medium_springaline_bud");
        RegistryHelper.register(registry, new AmethystClusterBlock(3, 4, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152492_).m_60918_(SoundType.f_154656_).m_60953_(s -> 1)), "small_springaline_bud");
        RegistryHelper.register(registry, new GlassBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(0.7f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_((a, b, c, d) -> false).m_60924_(ALWAYS_FALSE).m_60960_(ALWAYS_FALSE).m_60971_(ALWAYS_FALSE)), "springaline_glass");
        RegistryHelper.register(registry, new IronBarsBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(0.7f).m_60918_(SoundType.f_56744_).m_60955_()), "springaline_glass_pane");
    }

    @SubscribeEvent
    public static void initBlockEntities(RegistryEvent.Register<BlockEntityType<?>> evt) {
        IForgeRegistry r = evt.getRegistry();
        ECBlocks.register(r, ECBlocks.builder(SourceBlockEntity::new, SOURCE), "source");
        ECBlocks.register(r, ECBlocks.builder(ElementContainerBlockEntity::new, CONTAINER, SMALL_CONTAINER), "container");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(ReservoirBlockEntity::new, (Block[])new Block[]{FIRE_RESERVOIR, WATER_RESERVOIR, EARTH_RESERVOIR, AIR_RESERVOIR}), "reservoir");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(CreativeElementContainerBlockEntity::new, (Block[])new Block[]{CREATIVE_CONTAINER}), "creative_container");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(ExtractorBlockEntity::new, (Block[])new Block[]{EXTRACTOR, EXTRACTOR_IMPROVED}), "extractor");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(EvaporatorBlockEntity::new, (Block[])new Block[]{EVAPORATOR}), "evaporator");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(SolarSynthesizerBlockEntity::new, (Block[])new Block[]{SOLAR_SYNTHESIZER}), "solar_synthesizer");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(DiffuserBlockEntity::new, (Block[])new Block[]{DIFFUSER}), "diffuser");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(InfuserBlockEntity::new, (Block[])new Block[]{INFUSER}), "infuser");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(BinderBlockEntity::new, (Block[])new Block[]{BINDER}), "binder");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(ImprovedBinderBlockEntity::new, (Block[])new Block[]{BINDER_IMPROVED}), "binder_improved");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(CrystallizerBlockEntity::new, (Block[])new Block[]{CRYSTALLIZER}), "crystallizer");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(InscriberBlockEntity::new, (Block[])new Block[]{INSCRIBER}), "inscriber");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(AirMillBlockEntity::new, (Block[])new Block[]{AIR_MILL}), "air_mill");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(PedestalBlockEntity::new, (Block[])new Block[]{FIRE_PEDESTAL, WATER_PEDESTAL, EARTH_PEDESTAL, AIR_PEDESTAL}), "pedestal");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(PureInfuserBlockEntity::new, (Block[])new Block[]{PURE_INFUSER}), "pureinfuser");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(FireFurnaceBlockEntity::new, (Block[])new Block[]{FIRE_FURNACE}), "firefurnace");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(FireBlastFurnaceBlockEntity::new, (Block[])new Block[]{FIRE_BLAST_FURNACE}), "fireblastfurnace");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(PurifierBlockEntity::new, (Block[])new Block[]{PURIFIER}), "purifier");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(ElementPipeBlockEntity::new, (Block[])new Block[]{PIPE_IMPAIRED, PIPE, PIPE_IMPROVED}), "elementpipe");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(FirePylonBlockEntity::new, (Block[])new Block[]{FIRE_PYLON}), "firepylon");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(VacuumShrineBlockEntity::new, (Block[])new Block[]{VACUUM_SHRINE}), "vacuumshrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(GrowthShrineBlockEntity::new, (Block[])new Block[]{GROWTH_SHRINE}), "growthshrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(HarvestShrineBlockEntity::new, (Block[])new Block[]{HARVEST_SHRINE}), "harvestshrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(LavaShrineBlockEntity::new, (Block[])new Block[]{LAVA_SHRINE}), "lavashrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(OreShrineBlockEntity::new, (Block[])new Block[]{ORE_SHRINE}), "oreshrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(OverloadShrineBlockEntity::new, (Block[])new Block[]{OVERLOAD_SHRINE}), "overloadshrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(SweetShrineBlockEntity::new, (Block[])new Block[]{SWEET_SHRINE}), "sweetshrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(EnderLockShrineBlockEntity::new, (Block[])new Block[]{ENDER_LOCK_SHRINE}), "enderlockshrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(BreedingShrineBlockEntity::new, (Block[])new Block[]{BREEDING_SHRINE}), "breedingshrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(GroveShrineBlockEntity::new, (Block[])new Block[]{GROVE_SHRINE}), "groveshrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(SpringShrineBlockEntity::new, (Block[])new Block[]{SPRING_SHRINE}), "springshrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(BuddingShrineBlockEntity::new, (Block[])new Block[]{BUDDING_SHRINE}), "buddingshrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(SpawningShrineBlockEntity::new, (Block[])new Block[]{SPAWNING_SHRINE}), "spawningshrine");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(AccelerationShrineUpgradeBlockEntity::new, (Block[])new Block[]{ACCELERATION_SHRINE_UPGRADE}), "shrine_upgrade_acceleration");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(VortexShrineUpgradeBlockEntity::new, (Block[])new Block[]{VORTEX_SHRINE_UPGRADE}), "shrine_upgrade_vortex");
        ECBlocks.register(r, BlockEntityType.Builder.m_155273_(SorterBlockEntity::new, (Block[])new Block[]{SORTER}), "sorter");
        if (ECinteractions.isBotaniaActive()) {
            BotaniaInteractions.registerBlockEntities(r);
        }
    }

    @SafeVarargs
    public static <T extends BlockEntity> BlockEntityType.Builder<T> builder(BlockEntityType.BlockEntitySupplier<? extends T> pFactory, RegistryObject<? extends Block> ... pValidBlocks) {
        return BlockEntityType.Builder.m_155273_(pFactory, (Block[])((Block[])Arrays.stream(pValidBlocks).map(RegistryObject::get).toArray(Block[]::new)));
    }

    @SubscribeEvent
    public static void registerBlockItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        RegistryHelper.register(registry, new BlockItem((Block)FIREITE_BLOCK.get(), ECProperties.Items.FIREITE), FIREITE_BLOCK);
        for (Block block : ForgeRegistries.BLOCKS) {
            TooltipImageBlockItem blockItem;
            ResourceLocation registryName = block.getRegistryName();
            if (registryName == null || !"elementalcraft".equals(registryName.m_135827_()) || registry.containsKey(registryName)) continue;
            if (block instanceof AbstractElementContainerBlock) {
                AbstractElementContainerBlock containerBlock = (AbstractElementContainerBlock)block;
                blockItem = new ElementContainerBlockItem(containerBlock, ECProperties.Items.DEFAULT_ITEM_PROPERTIES);
            } else {
                blockItem = block instanceof ITooltipImageBlock ? new TooltipImageBlockItem(block, ECProperties.Items.DEFAULT_ITEM_PROPERTIES) : new BlockItem(block, ECProperties.Items.DEFAULT_ITEM_PROPERTIES);
            }
            RegistryHelper.register(registry, blockItem, registryName);
        }
    }

    private static <T extends BlockEntity> void register(IForgeRegistry<BlockEntityType<?>> registry, BlockEntityType.Builder<T> builder, RegistryObject<?> object) {
        ECBlocks.register(registry, builder, object.getId());
    }

    public static <T extends BlockEntity> void register(IForgeRegistry<BlockEntityType<?>> registry, BlockEntityType.Builder<T> builder, String name) {
        ECBlocks.register(registry, builder, ElementalCraft.createRL(name));
    }

    private static <T extends BlockEntity> void register(IForgeRegistry<BlockEntityType<?>> registry, BlockEntityType.Builder<T> builder, ResourceLocation name) {
        Type type = Util.m_137456_((DSL.TypeReference)References.f_16781_, (String)name.toString());
        RegistryHelper.register(registry, builder.m_58966_(type), name);
    }

    private static <T extends Block> RegistryObject<T> object(String name) {
        return RegistryHelper.object(name, ForgeRegistries.BLOCKS);
    }
}

