/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.container.ECContainerHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.property.ECProperties;

public abstract class AbstractECEntityBlock
extends BaseEntityBlock {
    protected AbstractECEntityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected AbstractECEntityBlock() {
        this(ECProperties.Blocks.BLOCK_NOT_SOLID);
    }

    @Nonnull
    @Deprecated
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Deprecated
    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropItems(level, pos);
            this.dropRunes(level, pos);
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    private void dropItems(Level worldIn, BlockPos pos) {
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)worldIn, pos, null);
        if (inv != null) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)inv.getStackInSlot(i));
            }
            worldIn.m_46717_(pos, (Block)this);
        }
    }

    private void dropRunes(Level worldIn, BlockPos pos) {
        BlockEntityHelper.getRuneHandlerAt((LevelReader)worldIn, pos).getRunes().forEach(rune -> Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)ECItems.RUNE.getRuneStack((Rune)rune)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return !level.f_46443_ ? (l, p, s, be) -> AbstractECEntityBlock.sendUpdate(be) : null;
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createECTicker(Level level, BlockEntityType<A> type, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return AbstractECEntityBlock.m_152132_(type, expectedType, !level.f_46443_ ? AbstractECEntityBlock.createUpdateTicker(ticker) : ticker);
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createECServerTicker(Level level, BlockEntityType<A> type, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return level.f_46443_ ? null : AbstractECEntityBlock.m_152132_(type, expectedType, AbstractECEntityBlock.createUpdateTicker(ticker));
    }

    private static <E extends BlockEntity> BlockEntityTicker<? super E> createUpdateTicker(BlockEntityTicker<? super E> ticker) {
        return (l, pos, state, be) -> {
            ticker.m_155252_(l, pos, state, be);
            AbstractECEntityBlock.sendUpdate(be);
        };
    }

    private static void sendUpdate(BlockEntity blockEntity) {
        if (blockEntity instanceof AbstractECBlockEntity) {
            AbstractECBlockEntity ecBlockEntity = (AbstractECBlockEntity)blockEntity;
            ecBlockEntity.sendUpdate();
        }
    }
}

