/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.source.trait;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValueProvider;

public class SourceTrait
implements Comparable<SourceTrait> {
    public static final String NAME = "source_traits";
    public static final String FOLDER = "elementalcraft_source_traits";
    public static final Codec<SourceTrait> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(SourceTrait::getChance), (App)Codec.INT.fieldOf("order").forGetter(SourceTrait::getOrder), (App)IBlockPosPredicate.CODEC.optionalFieldOf("predicate", (Object)IBlockPosPredicate.any()).forGetter(SourceTrait::getPredicate), (App)ISourceTraitValueProvider.CODEC.fieldOf("value").forGetter(t -> t.valueProvider)).apply((Applicative)builder, SourceTrait::new));
    private ResourceLocation id;
    private final float chance;
    private final int order;
    private final IBlockPosPredicate predicate;
    private final ISourceTraitValueProvider valueProvider;

    public static Builder builder() {
        return new Builder();
    }

    public SourceTrait(float chance, int order, IBlockPosPredicate predicate, ISourceTraitValueProvider valueProvider) {
        this.chance = chance;
        this.order = order;
        this.predicate = predicate;
        this.valueProvider = valueProvider;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public float getChance() {
        return this.chance;
    }

    public int getOrder() {
        return this.order;
    }

    public IBlockPosPredicate getPredicate() {
        return this.predicate;
    }

    @Nullable
    public ISourceTraitValue roll(Level level, BlockPos pos) {
        if (this.predicate.test((LevelReader)level, pos) && level.f_46441_.nextDouble() < (double)this.chance) {
            return this.valueProvider.roll(this, level, pos);
        }
        return null;
    }

    @Nullable
    public ISourceTraitValue load(Tag tag) {
        return this.valueProvider.load(tag);
    }

    @Nullable
    public Tag save(ISourceTraitValue value) {
        return this.valueProvider.save(value);
    }

    @Override
    public int compareTo(SourceTrait other) {
        return this.order - other.order;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof SourceTrait)) return false;
        SourceTrait trait = (SourceTrait)other;
        if (this.id == null) return false;
        if (!this.id.equals((Object)trait.id)) return false;
        return true;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public static class Builder {
        public static final Encoder<Builder> ENCODER = CODEC.comap(builder -> new SourceTrait(builder.chance, builder.order, builder.predicate, builder.valueProvider));
        private int order = 0;
        private float chance = 1.0f;
        private IBlockPosPredicate predicate = IBlockPosPredicate.any();
        private ISourceTraitValueProvider valueProvider;

        private Builder() {
        }

        public Builder chance(float chance) {
            this.chance = chance;
            return this;
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder predicate(IBlockPosPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder value(ISourceTraitValueProvider valueProvider) {
            this.valueProvider = valueProvider;
            return this;
        }
    }
}

