/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.transfer.path;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.transfer.CapabilityElementTransferer;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPath;
import sirttas.elementalcraft.api.element.transfer.path.InvalidElementTransferPath;

public class SimpleElementTransferPathfinder {
    private ElementType type = ElementType.NONE;
    private final Deque<AbstractNode> nodes;
    private final List<ProcessedNode> path;
    private final List<IElementTransferer> visited;
    private final Level level;
    private IElementStorage target;

    public SimpleElementTransferPathfinder(Level level) {
        this.level = level;
        this.nodes = new ArrayDeque<AbstractNode>();
        this.path = new ArrayList<ProcessedNode>();
        this.visited = new ArrayList<IElementTransferer>();
    }

    public IElementTransferPath findPath(ElementType type, IElementStorage source, IElementTransferer first, BlockPos start) {
        if (type != ElementType.NONE) {
            ProfilerFiller profiler = this.level.m_46473_();
            profiler.m_6180_("elementalcraft:simple_element_transfer_pathfinding");
            this.type = type;
            this.target = null;
            this.nodes.clear();
            this.path.clear();
            this.visited.clear();
            this.nodes.push(new ConnectNode(null, start, first, null));
            while (!this.nodes.isEmpty() && this.target == null) {
                this.nodes.pop().run();
            }
            profiler.m_7238_();
            if (this.target != null) {
                return new Path(source, this.target, type, this.path);
            }
        }
        return InvalidElementTransferPath.INSTANCE;
    }

    private class ConnectNode
    extends AbstractNode {
        private final IElementTransferer transferer;

        private ConnectNode(ConnectNode parent, BlockPos pos, IElementTransferer transferer, Direction side) {
            super(parent, pos, side);
            this.transferer = transferer;
        }

        @Override
        public void run() {
            this.transferer.getConnectionStream().forEach(entry -> {
                Direction side = (Direction)entry.getKey();
                Direction opposite = side.m_122424_();
                IElementTransferer.ConnectionType connection = (IElementTransferer.ConnectionType)((Object)((Object)entry.getValue()));
                if (connection == IElementTransferer.ConnectionType.INSERT) {
                    this.getConnectedCapability(side, CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY).ifPresent(s -> {
                        if (s.canPipeInsert(SimpleElementTransferPathfinder.this.type, opposite) && s.insertElement(1, SimpleElementTransferPathfinder.this.type, true) == 0) {
                            SimpleElementTransferPathfinder.this.nodes.push(new InsertNode(this, this.pos.m_142300_(side), (IElementStorage)s, opposite));
                        }
                    });
                } else if (connection == IElementTransferer.ConnectionType.CONNECT) {
                    this.getConnectedCapability(side, CapabilityElementTransferer.ELEMENT_TRANSFERER_CAPABILITY).ifPresent(t -> {
                        if (!SimpleElementTransferPathfinder.this.visited.contains(t) && t.isValid()) {
                            SimpleElementTransferPathfinder.this.visited.add((IElementTransferer)t);
                            SimpleElementTransferPathfinder.this.nodes.push(new ConnectNode(this, this.pos.m_142300_(side), (IElementTransferer)t, opposite));
                        }
                    });
                }
            });
        }

        private <T> LazyOptional<T> getConnectedCapability(Direction face, Capability<T> cap) {
            BlockEntity be = SimpleElementTransferPathfinder.this.level.m_7702_(this.pos.m_142300_(face));
            if (be != null) {
                return be.getCapability(cap, face.m_122424_());
            }
            return LazyOptional.empty();
        }
    }

    private abstract class AbstractNode
    implements Runnable {
        protected final ConnectNode parent;
        protected final BlockPos pos;
        protected final Direction side;

        private AbstractNode(ConnectNode parent, BlockPos pos, Direction side) {
            this.parent = parent;
            this.pos = pos;
            this.side = side;
        }
    }

    private record Path(IElementStorage source, IElementStorage target, ElementType type, List<ProcessedNode> path) implements IElementTransferPath
    {
        @Override
        public boolean isValid() {
            return !this.path.isEmpty() && this.source != null && this.target != null && this.path.stream().allMatch(ProcessedNode::isValid);
        }

        private int getRemainingTransferAmount() {
            return this.path.stream().mapToInt(node -> node.transferer.getRemainingTransferAmount()).min().orElse(0);
        }

        @Override
        public void transfer() {
            int remainingAmount;
            int amount;
            if (this.isValid() && (amount = this.source.extractElement(this.getRemainingTransferAmount(), this.type, true)) > 0 && (remainingAmount = amount - this.source.transferTo(this.target, this.type, amount)) > 0) {
                this.path.forEach(p -> p.transferer.transfer(remainingAmount));
            }
        }
    }

    private class InsertNode
    extends AbstractNode {
        private final IElementStorage storage;

        private InsertNode(ConnectNode parent, BlockPos pos, IElementStorage storage, Direction side) {
            super(parent, pos, side);
            this.storage = storage;
        }

        @Override
        public void run() {
            SimpleElementTransferPathfinder.this.target = this.storage;
            ConnectNode p = this.parent;
            while (p != null) {
                SimpleElementTransferPathfinder.this.path.add(new ProcessedNode(p.transferer, p.pos, p.side));
                p = p.parent;
            }
        }
    }

    private record ProcessedNode(IElementTransferer transferer, BlockPos pos, Direction side) {
        public boolean isValid() {
            return this.transferer.isValid() && (this.side == null || this.transferer.getConnection(this.side).isConnected());
        }
    }
}

