/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.transfer;

import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public interface IElementTransferer {
    default public ConnectionType getConnection(Direction face) {
        return this.getConnections().getOrDefault(face, ConnectionType.NONE);
    }

    public Map<Direction, ConnectionType> getConnections();

    default public Stream<Map.Entry<Direction, ConnectionType>> getConnectionStream() {
        return this.getConnections().entrySet().stream();
    }

    public int getRemainingTransferAmount();

    public void transfer(int var1);

    public boolean isValid();

    public static enum ConnectionType {
        NONE(0, "none", false),
        CONNECT(1, "connect", true),
        INSERT(2, "insert", true),
        EXTRACT(3, "extract", true),
        DISCONNECT(4, "disconnect", false);

        private final int value;
        private final String translationKey;
        private final boolean connected;

        private ConnectionType(int value, String key, boolean connected) {
            this.value = value;
            this.translationKey = "message.elementalcraft." + key;
            this.connected = connected;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public int getValue() {
            return this.value;
        }

        public static ConnectionType fromInteger(int x) {
            for (ConnectionType type : ConnectionType.values()) {
                if (type.getValue() != x) continue;
                return type;
            }
            return NONE;
        }

        public Component getDisplayName() {
            return new TranslatableComponent(this.translationKey);
        }
    }
}

