/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage.single;

import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;

public class SingleElementStorage
implements ISingleElementStorage,
INBTSerializable<CompoundTag> {
    protected int elementAmount;
    protected int elementCapacity;
    protected ElementType elementType;
    private final Runnable syncCallback;

    public SingleElementStorage(int elementCapacity) {
        this(elementCapacity, null);
    }

    public SingleElementStorage(int elementCapacity, Runnable syncCallback) {
        this(ElementType.NONE, 0, elementCapacity, syncCallback);
    }

    public SingleElementStorage(ElementType elementType, int elementAmount, int elementCapacity) {
        this(elementType, elementAmount, elementCapacity, null);
    }

    private SingleElementStorage(ElementType elementType, int elementAmount, int elementCapacity, Runnable syncCallback) {
        this.elementCapacity = elementCapacity;
        this.elementAmount = elementAmount;
        this.elementType = elementType;
        this.syncCallback = syncCallback;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    @Override
    public int getElementCapacity() {
        return this.elementCapacity;
    }

    @Override
    public int insertElement(int count, ElementType type, boolean simulate) {
        if (type != this.elementType && this.elementType != ElementType.NONE) {
            return count - this.extractElement(count, simulate);
        }
        int newCount = Math.min(this.elementAmount + count, this.elementCapacity);
        int ret = count - newCount + this.elementAmount;
        if (!simulate) {
            this.elementAmount = newCount;
            if (this.elementType == ElementType.NONE) {
                this.elementType = type;
            }
            if (ret < count) {
                this.markDirty();
            }
        }
        return ret;
    }

    @Override
    public int extractElement(int count, ElementType type, boolean simulate) {
        if (type != this.elementType) {
            return 0;
        }
        int newCount = Math.max(this.elementAmount - count, 0);
        int ret = this.elementAmount - newCount;
        if (!simulate) {
            this.elementAmount = newCount;
            if (this.elementAmount <= 0) {
                this.elementType = ElementType.NONE;
            }
            if (ret > 0) {
                this.markDirty();
            }
        }
        return ret;
    }

    public void markDirty() {
        if (this.syncCallback != null) {
            this.syncCallback.run();
        }
    }

    public String toString() {
        return this.elementAmount + "/" + this.elementCapacity + " " + this.elementType.m_7912_();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("element_type", this.getElementType().m_7912_());
        compound.m_128405_("element_amount", this.getElementAmount());
        compound.m_128405_("element_capacity", this.getElementCapacity());
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.elementType = ElementType.byName(compound.m_128461_("element_type"));
        this.elementAmount = compound.m_128451_("element_amount");
        this.elementCapacity = compound.m_128451_("element_capacity");
    }
}

