/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.storage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.storage.IElementStorage;

public class CapabilityElementStorage {
    public static final Capability<IElementStorage> ELEMENT_STORAGE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IElementStorage>(){});

    private CapabilityElementStorage() {
    }

    @Nonnull
    public static LazyOptional<IElementStorage> get(ICapabilityProvider provider) {
        return CapabilityElementStorage.get(provider, null);
    }

    @Nonnull
    public static LazyOptional<IElementStorage> get(ICapabilityProvider provider, Direction side) {
        return ELEMENT_STORAGE_CAPABILITY != null && provider != null ? provider.getCapability(ELEMENT_STORAGE_CAPABILITY, side) : LazyOptional.empty();
    }

    @Nullable
    public static <T extends Tag, S extends IElementStorage & INBTSerializable<T>> ICapabilityProvider createProvider(S storage) {
        return ELEMENT_STORAGE_CAPABILITY != null ? new CapabilityProvider(storage) : null;
    }

    private record CapabilityProvider<T extends Tag, S extends IElementStorage & INBTSerializable<T>>(S storage) implements ICapabilitySerializable<T>
    {
        @NotNull
        public <U> LazyOptional<U> getCapability(@NotNull Capability<U> cap, @Nullable Direction side) {
            return ELEMENT_STORAGE_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.storage));
        }

        public T serializeNBT() {
            return (T)((INBTSerializable)this.storage).serializeNBT();
        }

        public void deserializeNBT(T nbt) {
            ((INBTSerializable)this.storage).deserializeNBT(nbt);
        }
    }
}

