/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import sirttas.elementalcraft.api.element.IElementTypeProvider;

public enum ElementType implements StringRepresentable,
IElementTypeProvider
{
    NONE(0, 0, 0, "none"),
    WATER(43, 173, 255, "water"),
    FIRE(247, 107, 27, "fire"),
    EARTH(76, 133, 102, "earth"),
    AIR(238, 255, 219, "air");

    public static final List<ElementType> ALL_VALID;
    public static final Codec<ElementType> CODEC;
    public static final EnumProperty<ElementType> STATE_PROPERTY;
    private final float r;
    private final float g;
    private final float b;
    private final int color;
    private final String name;

    private ElementType(int r, int g, int b, String name) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.name = name;
        this.color = Mth.m_14159_((float)this.r, (float)this.g, (float)this.b);
    }

    public float getRed() {
        return this.r;
    }

    public float getGreen() {
        return this.g;
    }

    public float getBlue() {
        return this.b;
    }

    public int getColor() {
        return this == NONE ? -1 : this.color;
    }

    public static ElementType random() {
        return ElementType.random(new Random());
    }

    public static ElementType random(Random rand) {
        int random = rand.nextInt(4);
        return switch (random) {
            case 0 -> WATER;
            case 1 -> FIRE;
            case 2 -> EARTH;
            case 3 -> AIR;
            default -> NONE;
        };
    }

    @Nonnull
    public String m_7912_() {
        return this.name;
    }

    @Override
    public ElementType getElementType() {
        return this;
    }

    public String getTranslationKey() {
        return "element.elementalcraft." + this.m_7912_();
    }

    public Component getDisplayName() {
        return new TranslatableComponent(this.getTranslationKey());
    }

    public static ElementType byName(String name) {
        for (ElementType elementType : ElementType.values()) {
            if (!elementType.name.equals(name)) continue;
            return elementType;
        }
        return NONE;
    }

    public static ElementType getElementType(BlockState state) {
        if (state.m_61138_(STATE_PROPERTY)) {
            return (ElementType)((Object)state.m_61143_(STATE_PROPERTY));
        }
        Block block = state.m_60734_();
        if (block instanceof IElementTypeProvider) {
            IElementTypeProvider provider = (IElementTypeProvider)block;
            return provider.getElementType();
        }
        return NONE;
    }

    public static <T> RecordCodecBuilder<T, ElementType> forGetter(Function<T, ElementType> getter) {
        return CODEC.fieldOf("element_type").forGetter(getter);
    }

    static {
        ALL_VALID = ImmutableList.copyOf(Stream.of(ElementType.values()).filter(type -> type != NONE).toList());
        CODEC = StringRepresentable.m_14350_(ElementType::values, ElementType::byName);
        STATE_PROPERTY = EnumProperty.m_61587_((String)"element_type", ElementType.class);
    }
}

