/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.network;

import com.buuz135.findme.FindMeMod;
import com.buuz135.findme.network.PositionResponseMessage;
import com.buuz135.findme.tracking.TrackingList;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class PositionRequestMessage {
    private ItemStack stack;

    public PositionRequestMessage(ItemStack stack) {
        this.stack = stack;
        TrackingList.trackItem(stack);
    }

    public PositionRequestMessage() {
    }

    public static List<BlockPos> getBlockPosInAABB(AABB axisAlignedBB) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (double y = axisAlignedBB.f_82289_; y < axisAlignedBB.f_82292_; y += 1.0) {
            for (double x = axisAlignedBB.f_82288_; x < axisAlignedBB.f_82291_; x += 1.0) {
                for (double z = axisAlignedBB.f_82290_; z < axisAlignedBB.f_82293_; z += 1.0) {
                    blocks.add(new BlockPos(x, y, z));
                }
            }
        }
        return blocks;
    }

    public PositionRequestMessage fromBytes(ByteBuf buf) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(buf);
        this.stack = ItemStack.f_41583_;
        this.stack = packetBuffer.m_130267_();
        return this;
    }

    public void toBytes(ByteBuf buf) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(buf);
        packetBuffer.m_130055_(this.stack);
    }

    public static boolean compareItems(ItemStack first, ItemStack second) {
        if (!FindMeMod.CONFIG.COMMON.IGNORE_ITEM_DAMAGE) {
            return first.m_41726_(second);
        }
        return first.m_41656_(second);
    }

    public void handle(Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            AABB box = new AABB(((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().m_142538_()).m_82400_((double)FindMeMod.CONFIG.COMMON.RADIUS_RANGE);
            ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
            for (BlockPos blockPos : PositionRequestMessage.getBlockPosInAABB(box)) {
                BlockEntity tileEntity = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().f_19853_.m_7702_(blockPos);
                if (tileEntity == null || !FindMeMod.BLOCK_CHECKERS.stream().anyMatch(predicate -> predicate.test(tileEntity, this.stack))) continue;
                blockPosList.add(blockPos);
            }
            if (!blockPosList.isEmpty()) {
                FindMeMod.CHANNEL.sendToPlayer((ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)new PositionResponseMessage(blockPosList));
            }
        });
    }
}

