/*
 * Decompiled with CFR 0.152.
 */
package shadows.wstweaks;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import shadows.wstweaks.ItemImmolationBlade;
import shadows.wstweaks.WSTConfig;
import shadows.wstweaks.WitherSkeletonTweaks;

public class WSTLootModifier
extends LootModifier {
    protected WSTLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext ctx) {
        Entity ent = (Entity)ctx.m_78953_(LootContextParams.f_81455_);
        DamageSource src = (DamageSource)ctx.m_78953_(LootContextParams.f_81457_);
        if (src != null && ent != null && (src.f_19326_.equals("fireworks") || WSTLootModifier.hasSword(src))) {
            if (ent.getClass() == WitherSkeleton.class) {
                if (generatedLoot.stream().noneMatch(i -> i.m_41720_() == Items.f_42679_)) {
                    generatedLoot.add(new ItemStack((ItemLike)Items.f_42679_));
                }
            } else if (ent instanceof AbstractSkeleton) {
                generatedLoot.add(new ItemStack((ItemLike)Items.f_42678_));
            }
        }
        if (ent != null && ent.getClass() == WitherSkeleton.class && ctx.m_78933_().nextFloat() <= WSTConfig.shardDropChance && generatedLoot.stream().noneMatch(i -> i.m_41720_() == Items.f_42679_)) {
            generatedLoot.add(new ItemStack((ItemLike)WitherSkeletonTweaks.FRAGMENT));
        }
        return generatedLoot;
    }

    private static boolean hasSword(DamageSource source) {
        Entity s = source.m_7639_();
        if (s instanceof LivingEntity) {
            return ((LivingEntity)s).m_21205_().m_41720_() instanceof ItemImmolationBlade;
        }
        return false;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<WSTLootModifier> {
        public WSTLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new WSTLootModifier(conditions);
        }

        public JsonObject write(WSTLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

