/*
 * Decompiled with CFR 0.152.
 */
package shadows.wstweaks;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import shadows.wstweaks.WSTConfig;

@Mod.EventBusSubscriber(modid="wstweaks")
public class WSTEvents {
    @SubscribeEvent
    public static void witherTransform(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getEntity() instanceof Skeleton) {
            Skeleton entity = (Skeleton)event.getEntity();
            Level world = entity.f_19853_;
            Random rand = world.f_46441_;
            if (!event.getEntity().f_19853_.f_46443_) {
                double x = entity.m_20185_();
                double y = entity.m_20186_();
                double z = entity.m_20189_();
                if (world.m_46472_() == Level.f_46429_ || WSTConfig.allBiomes && event.getWorld().m_45524_(new BlockPos(x, y, z), 0) < 9 && rand.nextFloat() < WSTConfig.allBiomesChance) {
                    event.setCanceled(true);
                    entity.getPersistentData().m_128379_("wst.removed", true);
                    WitherSkeleton k = (WitherSkeleton)EntityType.f_20497_.m_20615_(world);
                    k.m_7678_(x, y, z, 0.0f, 0.0f);
                    world.m_7967_((Entity)k);
                    if (WSTConfig.giveBows) {
                        k.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void join(EntityJoinWorldEvent e) {
        if (e.getEntity().getPersistentData().m_128471_("wst.removed")) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void handleDropsEvent(LivingDropsEvent event) {
        WSTEvents.delSwords(event);
    }

    public static void delSwords(LivingDropsEvent event) {
        if (WSTConfig.delSwords && !event.getEntity().f_19853_.f_46443_ && event.getEntity() instanceof AbstractSkeleton) {
            ArrayList<ItemEntity> toRemove = new ArrayList<ItemEntity>();
            for (ItemEntity entity : event.getDrops()) {
                CompoundTag tag;
                ItemStack stack = entity.m_32055_();
                if (stack.m_41720_() != Items.f_42425_ && stack.m_41720_() != Items.f_42411_ || (tag = stack.m_41783_()) != null && (tag.m_128441_("Damage") && tag.m_128431_().size() > 2 || tag.m_128431_().size() > 1)) continue;
                toRemove.add(entity);
            }
            for (ItemEntity i : toRemove) {
                event.getDrops().remove(i);
            }
        }
    }
}

