/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.player;

import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.player.PlayerJS;
import dev.latvian.mods.kubejs.util.MessageSender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class EntityArrayList
extends ArrayList<EntityJS>
implements MessageSender {
    private final LevelJS level;

    public EntityArrayList(LevelJS l, int size) {
        super(size);
        this.level = l;
    }

    public EntityArrayList(LevelJS l, Iterable<? extends Entity> entities) {
        int n;
        if (entities instanceof Collection) {
            Collection c = (Collection)entities;
            n = c.size();
        } else {
            n = 10;
        }
        this(l, n);
        for (Entity entity : entities) {
            this.add(this.level.getEntity(entity));
        }
    }

    public LevelJS getLevel() {
        return this.level;
    }

    @Override
    public Component getName() {
        return new TextComponent("EntityList");
    }

    @Override
    public Component getDisplayName() {
        return new TextComponent(this.toString()).lightPurple();
    }

    @Override
    public void tell(Component message) {
        for (EntityJS entity : this) {
            entity.minecraftEntity.m_6352_(message, Util.f_137441_);
        }
    }

    @Override
    public void setStatusMessage(Component message) {
        for (EntityJS entity : this) {
            Entity entity2 = entity.minecraftEntity;
            if (!(entity2 instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity2;
            player.m_5661_(message, true);
        }
    }

    @Override
    public int runCommand(String command) {
        int m = 0;
        for (EntityJS entity : this) {
            m = Math.max(m, entity.runCommand(command));
        }
        return m;
    }

    @Override
    public int runCommandSilent(String command) {
        int m = 0;
        for (EntityJS entity : this) {
            m = Math.max(m, entity.runCommandSilent(command));
        }
        return m;
    }

    public void kill() {
        for (EntityJS entity : this) {
            entity.kill();
        }
    }

    public void playSound(SoundEvent id, float volume, float pitch) {
        for (EntityJS entity : this) {
            entity.minecraftEntity.f_19853_.m_6263_(null, entity.getX(), entity.getY(), entity.getZ(), id, entity.minecraftEntity.m_5720_(), volume, pitch);
        }
    }

    public void playSound(SoundEvent id) {
        this.playSound(id, 1.0f, 1.0f);
    }

    public EntityArrayList filter(Predicate<EntityJS> filter) {
        if (this.isEmpty()) {
            return this;
        }
        EntityArrayList list = new EntityArrayList(this.level, this.size());
        for (EntityJS entity : this) {
            if (!filter.test(entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public void sendData(String channel, @Nullable CompoundTag data) {
        for (EntityJS entity : this) {
            if (!(entity instanceof PlayerJS)) continue;
            PlayerJS playerJS = (PlayerJS)entity;
            playerJS.sendData(channel, data);
        }
    }

    @Override
    public EntityJS getFirst() {
        return (EntityJS)this.get(0);
    }
}

