/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient.forge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.core.IngredientKJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientWithCustomPredicateJS;
import dev.latvian.mods.kubejs.recipe.RecipeEventJS;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomPredicateIngredient
extends Ingredient {
    public static final IIngredientSerializer<CustomPredicateIngredient> SERIALIZER = new IIngredientSerializer<CustomPredicateIngredient>(){

        public CustomPredicateIngredient parse(FriendlyByteBuf buf) {
            return new CustomPredicateIngredient(Ingredient.m_43940_((FriendlyByteBuf)buf), buf.m_130259_(), false);
        }

        public CustomPredicateIngredient parse(JsonObject json) {
            return new CustomPredicateIngredient(CraftingHelper.getIngredient((JsonElement)json.get("ingredient")), UUID.fromString(json.get("uuid").getAsString()), true);
        }

        public void write(FriendlyByteBuf buf, CustomPredicateIngredient ingredient) {
            ingredient.ingredient.m_43923_(buf);
            buf.m_130077_(ingredient.uuid);
        }
    };
    private final Ingredient ingredient;
    private final UUID uuid;
    private final boolean isServer;

    private CustomPredicateIngredient(Ingredient in, UUID id, boolean s) {
        super(Stream.empty());
        this.ingredient = in;
        this.uuid = id;
        this.isServer = s;
    }

    @NotNull
    public ItemStack[] m_43908_() {
        return ((IngredientKJS)this.ingredient).getItemsKJS();
    }

    @NotNull
    public IntList m_43931_() {
        return this.ingredient.m_43931_();
    }

    public boolean test(@Nullable ItemStack target) {
        if (this.isServer && target != null && this.ingredient.test(target) && RecipeEventJS.customIngredientMap != null) {
            IngredientWithCustomPredicateJS i = RecipeEventJS.customIngredientMap.get(this.uuid);
            return i != null && i.predicate.test(target);
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<CustomPredicateIngredient> getSerializer() {
        return SERIALIZER;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "kubejs:custom_predicate");
        json.add("ingredient", this.ingredient.m_43942_());
        json.addProperty("uuid", this.uuid.toString());
        return json;
    }

    public boolean m_43947_() {
        return this.ingredient.m_43947_();
    }
}

