/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import dev.latvian.mods.kubejs.block.custom.ShapedBlockBuilder;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;

public class StonePressurePlateBlockBuilder
extends ShapedBlockBuilder {
    public StonePressurePlateBlockBuilder(ResourceLocation i) {
        super(i, "_stone_pressure_plate", "_pressure_plate");
        this.noCollision();
        this.tagBoth(BlockTags.f_13099_.f_203868_());
        this.tagBoth(BlockTags.f_13101_.f_203868_());
    }

    @Override
    public Block createObject() {
        return new PressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, this.createProperties());
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        generator.blockState(this.id, bs -> {
            bs.variant("powered=true", v -> v.model(this.newID("block/", "_down").toString()));
            bs.variant("powered=false", v -> v.model(this.newID("block/", "_up").toString()));
        });
        String texture = this.textures.get("texture").getAsString();
        generator.blockModel(this.newID("", "_down"), m -> {
            m.parent("minecraft:block/pressure_plate_down");
            m.texture("texture", texture);
        });
        generator.blockModel(this.newID("", "_up"), m -> {
            m.parent("minecraft:block/pressure_plate_up");
            m.texture("texture", texture);
        });
        generator.itemModel(this.itemBuilder.id, m -> m.parent(this.newID("block/", "_up").toString()));
    }
}

