/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class CommonProperties {
    private static CommonProperties instance;
    private final Properties properties;
    private boolean writeProperties;
    public boolean hideServerScriptErrors;
    public boolean serverOnly;
    public boolean announceReload;
    public boolean disableClassFilter;
    public String packMode;
    public boolean debugInfo;
    public boolean printRemappedClasses;

    public static CommonProperties get() {
        if (instance == null) {
            instance = new CommonProperties();
        }
        return instance;
    }

    private CommonProperties() {
        block16: {
            this.properties = new Properties();
            try {
                Path propertiesFile = KubeJSPaths.CONFIG.resolve("common.properties");
                this.writeProperties = false;
                if (Files.exists(propertiesFile, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(propertiesFile);){
                        this.properties.load(reader);
                    }
                } else {
                    this.writeProperties = true;
                }
                this.hideServerScriptErrors = this.get("hideServerScriptErrors", false);
                this.serverOnly = this.get("serverOnly", false);
                this.announceReload = this.get("announceReload", true);
                this.disableClassFilter = this.get("disableClassFilter", false);
                this.packMode = this.get("packmode", "default");
                this.debugInfo = this.get("debugInfo", false);
                this.printRemappedClasses = this.get("printRemappedClasses", false);
                if (!this.writeProperties) break block16;
                try (BufferedWriter writer = Files.newBufferedWriter(propertiesFile, new OpenOption[0]);){
                    this.properties.store(writer, "KubeJS Common Properties");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        KubeJS.LOGGER.info("Loaded common.properties");
    }

    private void remove(String key) {
        String s = this.properties.getProperty(key);
        if (s != null) {
            this.properties.remove(key);
            this.writeProperties = true;
        }
    }

    private String get(String key, String def) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            this.properties.setProperty(key, def);
            this.writeProperties = true;
            return def;
        }
        return s;
    }

    private boolean get(String key, boolean def) {
        return this.get(key, def ? "true" : "false").equals("true");
    }
}

