/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal;

import at.petrak.paucal.PaucalConfig;
import at.petrak.paucal.api.forge.datagen.lootmod.PaucalLootMods;
import at.petrak.paucal.common.Contributors;
import at.petrak.paucal.common.ModSounds;
import at.petrak.paucal.common.ModStats;
import at.petrak.paucal.common.advancement.ModAdvancementTriggers;
import at.petrak.paucal.common.command.ModCommands;
import at.petrak.paucal.common.misc.NewWorldMessage;
import at.petrak.paucal.common.misc.PatPat;
import at.petrak.paucal.forge.ForgePaucalConfig;
import at.petrak.paucal.xplat.IXplatAbstractions;
import com.mojang.brigadier.CommandDispatcher;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="paucal")
public class ForgePaucalInit {
    public ForgePaucalInit() {
        IXplatAbstractions.INSTANCE.init();
        Pair specPair = new ForgeConfigSpec.Builder().configure(ForgePaucalConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)specPair.getRight());
        PaucalConfig.setCommon((PaucalConfig.ConfigAccess)specPair.getLeft());
        ModAdvancementTriggers.registerTriggers();
        ForgePaucalInit.bind(ForgeRegistries.SOUND_EVENTS, ModSounds::init);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus evBus = MinecraftForge.EVENT_BUS;
        modBus.addGenericListener(Item.class, evt -> ModStats.register());
        evBus.addListener(evt -> {
            InteractionResult result = PatPat.onPat(evt.getPlayer(), evt.getWorld(), evt.getHand(), evt.getTarget(), null);
            if (result == InteractionResult.SUCCESS) {
                evt.setCanceled(true);
                evt.setCancellationResult(InteractionResult.SUCCESS);
            }
        });
        evBus.addListener(evt -> ModCommands.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher()));
        evBus.addListener(evt -> NewWorldMessage.onLogin(evt.getPlayer()));
        PaucalLootMods.LOOT_MODS.register(modBus);
        Contributors.loadContributors();
    }

    private static <T extends IForgeRegistryEntry<T>> void bind(IForgeRegistry<T> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(registry.getRegistrySuperType(), event -> {
            IForgeRegistry forgeRegistry = event.getRegistry();
            source.accept((t, rl) -> {
                t.setRegistryName(rl);
                forgeRegistry.register(t);
            });
        });
    }
}

