/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tools.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class FluidUtils {
    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void color(int color) {
        RenderSystem.m_157429_((float)FluidUtils.getRed(color), (float)FluidUtils.getGreen(color), (float)FluidUtils.getBlue(color), (float)FluidUtils.getAlpha(color));
    }

    @Nullable
    public static TextureAtlasSprite getFluidTexture(@Nonnull FluidStack stack) {
        FluidAttributes fa = stack.getFluid().getAttributes();
        ResourceLocation still = fa.getStillTexture(stack);
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(still);
    }

    public static int getLiquidColorWithBiome(@Nonnull FluidStack fluid, Level level, BlockPos pos) {
        if (level.f_46443_ && fluid.isFluidEqual(new FluidStack((Fluid)Fluids.f_76193_, 1000))) {
            return BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)pos) | 0xFF000000;
        }
        return fluid.getFluid().getAttributes().getColor(fluid);
    }

    public static int getLiquidColorWithBiome(@Nonnull FluidStack fluid, @Nonnull BlockEntity tileEntity) {
        return FluidUtils.getLiquidColorWithBiome(fluid, tileEntity.m_58904_(), tileEntity.m_58899_());
    }
}

