/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetContainerContents;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseLootTableProvider
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private final DataGenerator generator;

    public BaseLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    protected abstract void addTables();

    protected LootTable.Builder createStandardTable(Block block, BlockEntityType blockEntityType) {
        String name = block.getRegistryName().m_135815_();
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("Frequency", "DimStorage.Frequency", CopyNbtFunction.MergeStrategy.REPLACE)).m_5577_((LootItemFunction.Builder)SetContainerContents.m_193036_((BlockEntityType)blockEntityType).m_80930_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)new ResourceLocation("minecraft", "contents")))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    public void m_6865_(HashCache cache) {
        this.addTables();
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().m_60589_(), entry.getValue().m_79165_(LootContextParamSets.f_81421_).m_79167_());
        }
        this.writeTables(cache, tables);
    }

    private void writeTables(HashCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.m_123916_();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.m_135827_() + "/loot_tables/" + key.m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
            }
        });
    }

    public String m_6055_() {
        return "DimStorage LootTables";
    }
}

