/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.compat.top;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.compat.top.FluidElement;
import java.util.function.Function;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TOPProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider((IProbeInfoProvider)this);
        probe.registerElementFactory(new IElementFactory(){

            public IElement createElement(FriendlyByteBuf friendlyByteBuf) {
                return new FluidElement(friendlyByteBuf);
            }

            public ResourceLocation getId() {
                return FluidElement.ID;
            }
        });
        return null;
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, BlockState state, IProbeHitData data) {
        BlockEntity te = level.m_7702_(data.getPos());
        if (te instanceof BlockEntityFrequencyOwner) {
            BlockEntityFrequencyOwner owner = (BlockEntityFrequencyOwner)te;
            Frequency frequency = owner.getFrequency();
            if (frequency.hasOwner()) {
                if (owner.canAccess(player)) {
                    probeInfo.horizontal().text((Component)new TextComponent(ChatFormatting.GREEN + "Owner: " + frequency.getOwner()));
                } else {
                    probeInfo.horizontal().text((Component)new TextComponent(ChatFormatting.RED + "Owner: " + frequency.getOwner()));
                }
            }
            probeInfo.horizontal().text((Component)new TextComponent("Frequency: " + frequency.getChannel()));
            if (owner.locked) {
                probeInfo.horizontal().text((Component)new TextComponent("Locked: Yes"));
            }
            if (te instanceof BlockEntityDimTank) {
                BlockEntityDimTank tank = (BlockEntityDimTank)te;
                if (tank.autoEject) {
                    probeInfo.horizontal().text((Component)new TextComponent("Auto-eject: Yes"));
                }
                if (!tank.liquidState.serverLiquid.isEmpty()) {
                    probeInfo.element((IElement)new FluidElement(tank, 16000));
                }
            }
        }
    }

    public ResourceLocation getID() {
        return new ResourceLocation("dimstorage", "default");
    }
}

