/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.compat.top;

import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.compat.top.TOPElement;
import edivad.dimstorage.tools.utils.FluidUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidElement
extends TOPElement {
    public static final ResourceLocation ID = new ResourceLocation("dimstorage", "fluid_element");
    protected final FluidStack fluid;
    protected final int capacity;
    protected final int colorLiquid;

    protected FluidElement(FluidStack fluid, int capacity, int colorLiquid) {
        super(-16777216, 0xFFFFFF);
        this.fluid = fluid;
        this.capacity = capacity;
        this.colorLiquid = colorLiquid;
    }

    public FluidElement(BlockEntityDimTank blockentity, int capacity) {
        this(blockentity.liquidState.serverLiquid, capacity, FluidUtils.getLiquidColorWithBiome(blockentity.liquidState.serverLiquid, blockentity));
    }

    public FluidElement(FriendlyByteBuf buf) {
        this(buf.readFluidStack(), buf.readInt(), buf.readInt());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFluidStack(this.fluid);
        buf.writeInt(this.capacity);
        buf.writeInt(this.colorLiquid);
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.capacity == 0 || this.fluid.getAmount() == Integer.MAX_VALUE) {
            return level;
        }
        return this.fluid.getAmount() * level / this.capacity;
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.fluid.isEmpty() ? null : FluidUtils.getFluidTexture(this.fluid);
    }

    @Override
    public TextComponent getText() {
        String liquidText = this.fluid.getDisplayName().getString();
        int amount = this.fluid.getAmount();
        return new TextComponent(String.format("%s: %dmB", liquidText, amount));
    }

    @Override
    protected boolean applyRenderColor() {
        FluidUtils.color(this.colorLiquid);
        return true;
    }

    public ResourceLocation getID() {
        return ID;
    }
}

