/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.client.screen.element.button.AutoEjectButton;
import edivad.dimstorage.client.screen.pattern.FrequencyScreen;
import edivad.dimstorage.container.ContainerDimTank;
import edivad.dimstorage.tools.utils.FluidUtils;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class ScreenDimTank
extends FrequencyScreen<ContainerDimTank> {
    private static final ResourceLocation DIMTANK_GUI = new ResourceLocation("dimstorage", "textures/gui/dimtank.png");
    private String liquid;
    private String amount;
    private String temperature;
    private String luminosity;
    private String gaseous;
    private String empty;
    private String yes;
    private String no;

    public ScreenDimTank(ContainerDimTank container, Inventory inventory, Component text) {
        super(container, container.owner, inventory, text, DIMTANK_GUI, container.isOpen);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.addComponent((AbstractWidget)new AutoEjectButton(this.f_96543_ / 2 + 95, this.f_96544_ / 2 + 75, (BlockEntityDimTank)this.blockEntityFrequencyOwner));
        this.drawSettings(this.drawSettings);
        this.liquid = new TranslatableComponent("gui.dimstorage.liquid").getString();
        this.amount = new TranslatableComponent("gui.dimstorage.amount").getString();
        this.temperature = new TranslatableComponent("gui.dimstorage.temperature").getString();
        this.luminosity = new TranslatableComponent("gui.dimstorage.luminosity").getString();
        this.gaseous = new TranslatableComponent("gui.dimstorage.gas").getString();
        this.empty = new TranslatableComponent("gui.dimstorage.empty").getString();
        this.yes = new TranslatableComponent("gui.dimstorage.yes").getString();
        this.no = new TranslatableComponent("gui.dimstorage.no").getString();
    }

    @Override
    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7027_(poseStack, mouseX, mouseY);
        FluidStack liquidStack = ((BlockEntityDimTank)this.blockEntityFrequencyOwner).liquidState.clientLiquid;
        if (!liquidStack.isEmpty()) {
            FluidAttributes liquidAttributes = liquidStack.getFluid().getAttributes();
            String liquidName = liquidStack.getDisplayName().getString();
            this.f_96547_.m_92883_(poseStack, this.liquid + " " + liquidName.substring(0, Math.min(14, liquidName.length())), 50.0f, 25.0f, 0x404040);
            this.f_96547_.m_92883_(poseStack, this.amount + " " + liquidStack.getAmount() + " mB", 50.0f, 35.0f, 0x404040);
            this.f_96547_.m_92883_(poseStack, this.temperature + " " + (liquidAttributes.getTemperature() - 273) + "C", 50.0f, 45.0f, 0x404040);
            this.f_96547_.m_92883_(poseStack, this.luminosity + " " + liquidAttributes.getLuminosity(), 50.0f, 55.0f, 0x404040);
            this.f_96547_.m_92883_(poseStack, this.gaseous + " " + (liquidAttributes.isGaseous() ? this.yes : this.no), 50.0f, 65.0f, 0x404040);
        } else {
            this.f_96547_.m_92883_(poseStack, this.liquid + " " + this.empty, 50.0f, 25.0f, 0x404040);
        }
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        FluidStack fluid = ((BlockEntityDimTank)this.blockEntityFrequencyOwner).liquidState.clientLiquid;
        int z = ScreenDimTank.getFluidScaled(60, fluid.getAmount());
        TextureAtlasSprite fluidTexture = FluidUtils.getFluidTexture(fluid);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        FluidUtils.color(FluidUtils.getLiquidColorWithBiome(fluid, this.blockEntityFrequencyOwner));
        ScreenDimTank.m_93200_((PoseStack)poseStack, (int)(this.f_97735_ + 11), (int)(this.f_97736_ + 21 + z), (int)176, (int)16, (int)(60 - z), (TextureAtlasSprite)fluidTexture);
    }

    private static int getFluidScaled(int pixels, int currentLiquidAmount) {
        int maxLiquidAmount = 16000;
        int x = currentLiquidAmount * pixels / maxLiquidAmount;
        return pixels - x;
    }
}

