/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.monitor.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.monitor.MonitorModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PowerLevelTileEntity
extends TickingTileEntity {
    private final LogicSupport support = new LogicSupport();
    private int counter = 20;

    public PowerLevelTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MonitorModule.TYPE_POWER_LEVEL.get(), pos, state);
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(PowerLevelTileEntity::new));
    }

    public LogicSupport getLogicSupport() {
        return this.support;
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("power", this.support.getPowerOutput());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.support.setPowerOutput(tag.m_128451_("power"));
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        this.saveInfo(tagCompound);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.loadInfo(tagCompound);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    protected void tickServer() {
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 10;
        Direction inputSide = LogicSupport.getFacing((BlockState)this.f_58857_.m_8055_(this.m_58899_())).getInputSide();
        BlockPos inputPos = this.m_58899_().m_142300_(inputSide);
        BlockEntity tileEntity = this.f_58857_.m_7702_(inputPos);
        if (!EnergyTools.isEnergyTE((BlockEntity)tileEntity, null)) {
            this.support.setRedstoneState((GenericTileEntity)this, 0);
            return;
        }
        EnergyTools.EnergyLevel energy = EnergyTools.getEnergyLevelMulti((BlockEntity)tileEntity, null);
        long maxEnergy = energy.maxEnergy();
        int ratio = 0;
        if (maxEnergy > 0L) {
            long stored = energy.energy();
            ratio = (int)(stored * 10L / maxEnergy);
            if (ratio < 0) {
                ratio = 0;
            } else if (ratio > 9) {
                ratio = 9;
            }
        }
        if (this.support.getPowerOutput() != ratio) {
            this.support.setRedstoneState((GenericTileEntity)this, ratio);
            this.markDirtyClient();
        }
    }
}

