/*
 * Decompiled with CFR 0.152.
 */
package io.github.samarium150.minecraft.mod.structures_compass.network.packet;

import io.github.samarium150.minecraft.mod.structures_compass.gui.StructuresCompassGUI;
import io.github.samarium150.minecraft.mod.structures_compass.network.packet.Packet;
import io.github.samarium150.minecraft.mod.structures_compass.util.GeneralUtils;
import io.github.samarium150.minecraft.mod.structures_compass.util.Serializer;
import io.github.samarium150.minecraft.mod.structures_compass.util.StructureUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public final class SyncPacket
implements Packet,
Serializer<HashMap<String, List<String>>> {
    private final ItemStack stack;
    private final List<StructureFeature<?>> allowed;
    private final HashMap<String, List<String>> map;

    public SyncPacket(ItemStack stack, List<StructureFeature<?>> allowed, HashMap<String, List<String>> map) {
        this.stack = stack;
        this.allowed = allowed;
        this.map = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncPacket(@Nonnull FriendlyByteBuf buffer) {
        this.stack = buffer.m_130267_();
        this.allowed = new ArrayList();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.allowed.add(StructureUtils.getStructureForResource(buffer.m_130281_()));
        }
        HashMap temp = new HashMap();
        size = buffer.readInt();
        StringBuilder serialized = new StringBuilder();
        try {
            for (int i = 0; i < size; ++i) {
                serialized.append(buffer.m_130277_());
            }
            temp = (HashMap)this.deserialize(serialized.toString());
            temp.replaceAll((k, v) -> v.stream().map(StructureUtils::getLocalizedDimensionName).collect(Collectors.toList()));
        }
        catch (Exception e) {
            GeneralUtils.logger.error((Object)e);
        }
        finally {
            this.map = temp;
        }
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buffer) {
        String serialized;
        buffer.m_130055_(this.stack);
        buffer.writeInt(this.allowed.size());
        this.allowed.forEach(structure -> buffer.m_130085_(StructureUtils.getResourceForStructure(structure)));
        try {
            serialized = this.serialize(this.map);
        }
        catch (Exception e) {
            GeneralUtils.logger.error((Object)e);
            return;
        }
        List<String> ret = GeneralUtils.splitEqually(serialized, 15000);
        int size = ret.size();
        buffer.writeInt(size);
        for (String s : ret) {
            buffer.m_130070_(s);
        }
    }

    @Override
    public void handle(@Nonnull Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            StructureUtils.allowedStructures = this.allowed;
            StructureUtils.structuresDimensionMap = this.map;
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> StructuresCompassGUI.openGUI(this.stack));
        });
        context.setPacketHandled(true);
    }
}

