/*
 * Decompiled with CFR 0.152.
 */
package io.github.samarium150.minecraft.mod.structures_compass.network.packet;

import io.github.samarium150.minecraft.mod.structures_compass.item.StructuresCompassItem;
import io.github.samarium150.minecraft.mod.structures_compass.network.packet.Packet;
import io.github.samarium150.minecraft.mod.structures_compass.util.ItemUtils;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public final class CompassSkipExistingChunksPacket
implements Packet {
    private final Boolean skip;

    public CompassSkipExistingChunksPacket(Boolean skip) {
        this.skip = skip;
    }

    public CompassSkipExistingChunksPacket(@Nonnull FriendlyByteBuf buffer) {
        this.skip = buffer.readBoolean();
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.skip.booleanValue());
    }

    @Override
    public void handle(@Nonnull Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ItemStack stack = ItemUtils.getHeldStructuresCompass((Player)player);
            if (!stack.m_41619_() && player != null) {
                StructuresCompassItem.setSkip(this.skip, stack);
            }
        });
        context.setPacketHandled(true);
    }
}

