/*
 * Decompiled with CFR 0.152.
 */
package io.github.samarium150.minecraft.mod.structures_compass.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import io.github.samarium150.minecraft.mod.structures_compass.util.GeneralUtils;
import io.github.samarium150.minecraft.mod.structures_compass.util.RenderUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TransparentTextField
extends EditBox {
    private final Font fontRenderer;
    private Component label;
    private int labelColor = 0x808080;
    private boolean pseudoIsEnabled = true;
    private boolean pseudoEnableBackgroundDrawing = true;
    private int pseudoMaxStringLength = 32;
    private int pseudoLineScrollOffset;
    private int pseudoEnabledColor = 0xE0E0E0;
    private int pseudoDisabledColor = 0x707070;
    private int pseudoCursorCounter;
    private int pseudoSelectionEnd;

    public TransparentTextField(Font fontRenderer, int x, int y, int width, int height, Component label) {
        super(fontRenderer, x, y, width, height, label);
        this.fontRenderer = fontRenderer;
        this.label = label;
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.m_94213_()) {
            boolean showLabel;
            if (this.pseudoEnableBackgroundDrawing) {
                int color = 433;
                RenderUtils.drawRect(this.f_93620_, this.f_93621_, this.f_93620_ + this.f_93618_, this.f_93621_ + this.f_93619_, -671088640);
            }
            boolean bl = showLabel = !this.m_93696_() && this.m_94155_().isEmpty();
            int i = showLabel ? this.labelColor : (this.pseudoIsEnabled ? this.pseudoEnabledColor : this.pseudoDisabledColor);
            int j = this.m_94207_() - this.pseudoLineScrollOffset;
            int k = this.pseudoSelectionEnd - this.pseudoLineScrollOffset;
            String text = showLabel ? this.label.getString() : this.m_94155_();
            String s = this.fontRenderer.m_92834_(text.substring(this.pseudoLineScrollOffset), this.m_5711_());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.m_93696_() && this.pseudoCursorCounter / 6 % 2 == 0 && flag;
            int l = this.pseudoEnableBackgroundDrawing ? this.f_93620_ + 4 : this.f_93620_;
            int i1 = this.pseudoEnableBackgroundDrawing ? this.f_93621_ + (this.f_93619_ - 8) / 2 : this.f_93621_;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = this.fontRenderer.m_92750_(matrixStack, s1, (float)l, (float)i1, i);
            }
            boolean flag2 = this.m_94207_() < this.m_94155_().length() || this.m_94155_().length() >= this.pseudoMaxStringLength;
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.f_93618_ : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                this.fontRenderer.m_92750_(matrixStack, s.substring(j), (float)j1, (float)i1, i);
            }
            if (flag1) {
                if (flag2) {
                    Objects.requireNonNull(this.fontRenderer);
                    RenderUtils.drawRect(k1, i1 - 1, k1 + 1, i1 + 1 + 9, -3092272);
                } else {
                    this.fontRenderer.m_92750_(matrixStack, "_", (float)k1, (float)i1, i);
                }
            }
            if (k != j) {
                int l1 = l + this.fontRenderer.m_92895_(s.substring(0, k));
                Objects.requireNonNull(this.fontRenderer);
                this.drawSelectionBox(k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
        }
    }

    public void m_94186_(boolean enabled) {
        super.m_94186_(enabled);
        this.pseudoIsEnabled = enabled;
    }

    public void m_94202_(int color) {
        super.m_94202_(color);
        this.pseudoEnabledColor = color;
    }

    public void m_94205_(int color) {
        super.m_94205_(color);
        this.pseudoDisabledColor = color;
    }

    public void m_93692_(boolean isFocused) {
        if (isFocused && !this.m_93696_()) {
            this.pseudoCursorCounter = 0;
        }
        super.m_93692_(isFocused);
    }

    public void m_94182_(boolean enableBackgroundDrawing) {
        super.m_94182_(enableBackgroundDrawing);
        this.pseudoEnableBackgroundDrawing = enableBackgroundDrawing;
    }

    public void m_94199_(int length) {
        super.m_94199_(length);
        this.pseudoMaxStringLength = length;
    }

    public void m_94120_() {
        super.m_94120_();
        ++this.pseudoCursorCounter;
    }

    public void m_94208_(int position) {
        super.m_94208_(position);
        int i = this.m_94155_().length();
        this.pseudoSelectionEnd = Mth.m_14045_((int)position, (int)0, (int)i);
        if (this.fontRenderer != null) {
            if (this.pseudoLineScrollOffset > i) {
                this.pseudoLineScrollOffset = i;
            }
            int j = this.m_94210_();
            String s = this.fontRenderer.m_92837_(this.m_94155_().substring(this.pseudoLineScrollOffset), j, false);
            int k = s.length() + this.pseudoLineScrollOffset;
            if (this.pseudoSelectionEnd == this.pseudoLineScrollOffset) {
                this.pseudoLineScrollOffset -= this.fontRenderer.m_92837_(this.m_94155_(), j, true).length();
            }
            if (this.pseudoSelectionEnd > k) {
                this.pseudoLineScrollOffset += this.pseudoSelectionEnd - k;
            } else if (this.pseudoSelectionEnd <= this.pseudoLineScrollOffset) {
                this.pseudoLineScrollOffset -= this.pseudoLineScrollOffset - this.pseudoSelectionEnd;
            }
            this.pseudoLineScrollOffset = Mth.m_14045_((int)this.pseudoLineScrollOffset, (int)0, (int)i);
        }
    }

    public void setLabel(Component label) {
        this.label = label;
    }

    public void setLabelColor(int labelColor) {
        this.labelColor = labelColor;
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            Integer[] integerArray = new Integer[2];
            integerArray[0] = endX;
            endX = startX;
            integerArray[1] = endX;
            startX = GeneralUtils.swap(integerArray);
        }
        if (startY < endY) {
            Integer[] integerArray = new Integer[2];
            integerArray[0] = endY;
            endY = startY;
            integerArray[1] = endY;
            startY = GeneralUtils.swap(integerArray);
        }
        if (endX > this.f_93620_ + this.f_93618_) {
            endX = this.f_93620_ + this.f_93618_;
        }
        if (startX > this.f_93620_ + this.f_93618_) {
            startX = this.f_93620_ + this.f_93618_;
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        RenderUtils.updateBuffer(buffer, startX, startY, endX, endY);
        tesselator.m_85914_();
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }
}

