/*
 * Decompiled with CFR 0.152.
 */
package io.github.samarium150.minecraft.mod.structures_compass.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.samarium150.minecraft.mod.structures_compass.config.StructuresCompassConfig;
import io.github.samarium150.minecraft.mod.structures_compass.init.ItemRegistry;
import io.github.samarium150.minecraft.mod.structures_compass.item.StructuresCompassItem;
import io.github.samarium150.minecraft.mod.structures_compass.util.GeneralUtils;
import io.github.samarium150.minecraft.mod.structures_compass.util.RenderUtils;
import io.github.samarium150.minecraft.mod.structures_compass.util.StructureUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public final class StructuresCompassHUD
extends GuiComponent {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private final PoseStack matrixStack;

    public StructuresCompassHUD(PoseStack matrixStack) {
        this.matrixStack = matrixStack;
    }

    public void render() {
        if ((Integer)StructuresCompassConfig.HUD_Level.get() != 0 && (StructuresCompassHUD.minecraft.f_91080_ == null || ((Boolean)StructuresCompassConfig.displayWithChatOpen.get()).booleanValue() && StructuresCompassHUD.minecraft.f_91080_ instanceof ChatScreen)) {
            ItemStack stack;
            LocalPlayer player = StructuresCompassHUD.minecraft.f_91074_;
            assert (player != null);
            if (!player.m_21205_().m_41619_() && player.m_21205_().m_41720_() == ItemRegistry.STRUCTURES_COMPASS.get()) {
                stack = player.m_21205_();
            } else if (!player.m_21206_().m_41619_() && player.m_21206_().m_41720_() == ItemRegistry.STRUCTURES_COMPASS.get()) {
                stack = player.m_21206_();
            } else {
                return;
            }
            if (stack.m_41720_() instanceof StructuresCompassItem) {
                String feature = StructuresCompassItem.getStructureName(stack);
                String dim = StructuresCompassItem.getDimension(stack);
                BlockPos pos = StructuresCompassItem.getPos(stack);
                int relLineOffset = 0;
                if (feature == null) {
                    return;
                }
                if (pos == null || dim == null) {
                    RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, I18n.m_118938_((String)(GeneralUtils.prefix + "hud_not_found"), (Object[])new Object[0]), 5, 5, 11149590, relLineOffset);
                } else {
                    RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, I18n.m_118938_((String)(GeneralUtils.prefix + "hud_structure"), (Object[])new Object[0]), 5, 5, 0xFFFFFF, relLineOffset);
                    RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, StructureUtils.getLocalizedStructureName(feature), 5, 5, 0xAAAAAA, ++relLineOffset);
                    ++relLineOffset;
                    RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, I18n.m_118938_((String)(GeneralUtils.prefix + "hud_dim"), (Object[])new Object[0]), 5, 5, 0xFFFFFF, ++relLineOffset);
                    RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, StructureUtils.getLocalizedDimensionName(dim), 5, 5, 0xAAAAAA, ++relLineOffset);
                    ++relLineOffset;
                    if ((Integer)StructuresCompassConfig.HUD_Level.get() == 3) {
                        Object temp = pos.m_123342_() == 0 ? ", X, " : ", " + pos.m_123342_() + ", ";
                        temp = I18n.m_118938_((String)(GeneralUtils.prefix + "hud_pos"), (Object[])new Object[0]) + " [" + pos.m_123341_() + (String)temp + pos.m_123343_() + "]";
                        RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, (String)temp, 5, 5, 0x4AFF4A, ++relLineOffset);
                    }
                    if (player.m_20193_().m_46472_().m_135782_().toString().equals(dim)) {
                        Vec3 dis = StructureUtils.getDistance(pos, (Entity)player);
                        double disX = dis.m_7096_();
                        double disY = dis.m_7098_();
                        double disZ = dis.m_7094_();
                        double distance = (double)Math.round(Math.sqrt(disX * disX + disY * disY + disZ * disZ) * 100.0) / 100.0;
                        if ((Integer)StructuresCompassConfig.HUD_Level.get() == 3 && disX > (Double)StructuresCompassConfig.closeEnough.get()) {
                            RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, I18n.m_118938_((String)(GeneralUtils.prefix + "hud_east"), (Object[])new Object[0]) + disX, 5, 5, 0xFFFFFF, ++relLineOffset);
                        } else if ((Integer)StructuresCompassConfig.HUD_Level.get() == 3 && disX < -((Double)StructuresCompassConfig.closeEnough.get()).doubleValue()) {
                            RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, I18n.m_118938_((String)(GeneralUtils.prefix + "hud_west"), (Object[])new Object[0]) + -disX, 5, 5, 0xFFFFFF, ++relLineOffset);
                        }
                        if ((Integer)StructuresCompassConfig.HUD_Level.get() == 3 && disZ > (Double)StructuresCompassConfig.closeEnough.get()) {
                            RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, I18n.m_118938_((String)(GeneralUtils.prefix + "hud_south"), (Object[])new Object[0]) + disZ, 5, 5, 0xFFFFFF, ++relLineOffset);
                        } else if ((Integer)StructuresCompassConfig.HUD_Level.get() == 3 && disZ < -((Double)StructuresCompassConfig.closeEnough.get()).doubleValue()) {
                            RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, I18n.m_118938_((String)(GeneralUtils.prefix + "hud_north"), (Object[])new Object[0]) + -disZ, 5, 5, 0xFFFFFF, ++relLineOffset);
                        }
                        if ((Integer)StructuresCompassConfig.HUD_Level.get() == 3 && disY > (Double)StructuresCompassConfig.closeEnough.get()) {
                            RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, I18n.m_118938_((String)(GeneralUtils.prefix + "hud_up"), (Object[])new Object[0]) + disY, 5, 5, 0xFFFFFF, ++relLineOffset);
                        } else if ((Integer)StructuresCompassConfig.HUD_Level.get() == 3 && disY < -((Double)StructuresCompassConfig.closeEnough.get()).doubleValue()) {
                            RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, I18n.m_118938_((String)(GeneralUtils.prefix + "hud_down"), (Object[])new Object[0]) + -disY, 5, 5, 0xFFFFFF, ++relLineOffset);
                        }
                        if ((Integer)StructuresCompassConfig.HUD_Level.get() == 3 && relLineOffset > 6 || (Integer)StructuresCompassConfig.HUD_Level.get() >= 2 && distance > (Double)StructuresCompassConfig.closeEnough.get()) {
                            ++relLineOffset;
                            RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, I18n.m_118938_((String)(GeneralUtils.prefix + "hud_distance"), (Object[])new Object[0]) + distance, 5, 5, 16761358, ++relLineOffset);
                        }
                    } else {
                        ++relLineOffset;
                        RenderUtils.drawConfiguredStringOnHUD(this.matrixStack, I18n.m_118938_((String)(GeneralUtils.prefix + "hud_wrong_dim"), (Object[])new Object[0]), 5, 5, 11149590, ++relLineOffset);
                    }
                }
            }
        }
    }
}

