/*
 * Decompiled with CFR 0.152.
 */
package io.github.samarium150.minecraft.mod.structures_compass.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.samarium150.minecraft.mod.structures_compass.gui.StructureSearchList;
import io.github.samarium150.minecraft.mod.structures_compass.gui.StructuresCompassScreen;
import io.github.samarium150.minecraft.mod.structures_compass.util.GeneralUtils;
import io.github.samarium150.minecraft.mod.structures_compass.util.StructureUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class StructureSearchEntry
extends ObjectSelectionList.Entry<StructureSearchEntry> {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final StructureSearchList list;
    private final StructureFeature<?> structure;
    private final StructuresCompassScreen screen;
    private long lastTickTime;

    public StructureSearchEntry(@Nonnull StructureSearchList list, StructureFeature<?> structure) {
        this.list = list;
        this.structure = structure;
        this.screen = list.getScreen();
    }

    public void search() {
        this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        this.screen.search(this.structure);
    }

    public StructureFeature<?> getStructure() {
        return this.structure;
    }

    public void m_6311_(@Nonnull PoseStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        this.minecraft.f_91062_.m_92883_(matrixStack, StructureUtils.getLocalizedStructureName(this.structure), (float)(left + 1), (float)(top + 1), 0xFFFFFF);
        Font font = this.minecraft.f_91062_;
        TextComponent textComponent = new TextComponent(I18n.m_118938_((String)(GeneralUtils.prefix + "source"), (Object[])new Object[0]) + ": " + StructureUtils.getStructureSource(this.structure));
        float f = left + 1;
        Objects.requireNonNull(this.minecraft.f_91062_);
        font.m_92889_(matrixStack, (Component)textComponent, f, (float)(top + 9 + 3), 0x808080);
        Font font2 = this.minecraft.f_91062_;
        TextComponent textComponent2 = new TextComponent(I18n.m_118938_((String)(GeneralUtils.prefix + "dimension"), (Object[])new Object[0]) + ": " + StructureUtils.getDimensions(this.structure));
        float f2 = left + 1;
        Objects.requireNonNull(this.minecraft.f_91062_);
        font2.m_92889_(matrixStack, (Component)textComponent2, f2, (float)(top + 9 + 14), 0x808080);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.list.selectStructure(this);
            if (Util.m_137550_() - this.lastTickTime < 250L) {
                this.search();
                return true;
            }
            this.lastTickTime = Util.m_137550_();
        }
        return false;
    }

    @Nonnull
    public Component m_142172_() {
        return new TextComponent(I18n.m_118938_((String)(GeneralUtils.prefix + "source"), (Object[])new Object[0]) + ": " + StructureUtils.getStructureSource(this.structure));
    }
}

