/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.ToolHelper;
import shetiphian.platforms.Configuration;
import shetiphian.platforms.common.block.BlockPlatformType;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class BlockPlatformFrame
extends BlockPlatformType.Singles {
    private static final VoxelShape SHAPE_CORE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_STEP = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_PLACE = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_FRAME = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)3.0), Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0)});
    private static final VoxelShape SHAPE_AX = Shapes.m_83124_((VoxelShape)SHAPE_FRAME, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)5.0, (double)16.0), Block.m_49796_((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)1.0), Block.m_49796_((double)0.0, (double)11.0, (double)15.0, (double)16.0, (double)14.0, (double)16.0)});
    private static final VoxelShape SHAPE_AZ = Shapes.m_83124_((VoxelShape)SHAPE_FRAME, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0), Block.m_49796_((double)15.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)5.0, (double)1.0), Block.m_49796_((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)5.0, (double)16.0)});

    public BlockPlatformFrame() {
        super(EnumPlatformType.FRAME);
    }

    public boolean isScaffolding(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return ((Configuration.Menu_General.ClimbMode)((Object)Configuration.GENERAL.frameClimbMode.get())).sneakDescend();
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Configuration.Menu_General.ClimbMode climbMode = (Configuration.Menu_General.ClimbMode)((Object)Configuration.GENERAL.frameClimbMode.get());
        if (climbMode == Configuration.Menu_General.ClimbMode.NONE) {
            return Shapes.m_83144_();
        }
        if (climbMode.sneakDescend() && !context.m_6513_(SHAPE_CORE, pos, true) && context.m_6513_(SHAPE_STEP, pos, true) && !context.m_6226_()) {
            return SHAPE_STEP;
        }
        return climbMode == Configuration.Menu_General.ClimbMode.SCAFFOLD ? Shapes.m_83040_() : SHAPE_CORE;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (context.m_7142_(this.m_5456_())) {
            return SHAPE_PLACE;
        }
        if (context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).m_193113_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (InteractionHand hand : InteractionHand.values()) {
                if (!ToolHelper.isWrench((ItemStack)living.m_21120_(hand))) continue;
                return SHAPE_PLACE;
            }
        }
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? SHAPE_AX : SHAPE_AZ;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        EnumTorchType torch;
        TileEntityPlatformBase tile = BlockPlatformFrame.getTile(world, pos);
        if (tile != null && (torch = TileHelper.getTorch(tile)) != null) {
            switch (torch) {
                case REDSTONE_ON: {
                    return Blocks.f_50174_.m_49966_().m_60791_();
                }
                case LIGHT: {
                    return Blocks.f_50081_.m_49966_().m_60791_();
                }
                case GLOWSTONE: 
                case SOULSTONE: {
                    return Blocks.f_50141_.m_49966_().m_60791_();
                }
                case LAMP_ON: {
                    return ((BlockState)Blocks.f_50261_.m_49966_().m_61124_((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(true))).m_60791_();
                }
                case SOUL: {
                    return Blocks.f_50139_.m_49966_().m_60791_();
                }
            }
        }
        return super.getLightEmission(state, world, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        EnumTorchType torch;
        TileEntityPlatformBase tile = BlockPlatformFrame.getTile((BlockGetter)world, pos);
        if (TileHelper.hasTorch(tile) && (torch = TileHelper.getTorch(tile)) != null) {
            double x = (float)pos.m_123341_() + 0.5f;
            double y = (float)pos.m_123342_() + 0.75f;
            double z = (float)pos.m_123343_() + 0.5f;
            switch (torch) {
                case REDSTONE_ON: 
                case LAMP_ON: {
                    world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x += (double)(rand.nextFloat() - 0.5f) * 0.2, y += (double)(rand.nextFloat() - 0.5f) * 0.2, z += (double)(rand.nextFloat() - 0.5f) * 0.2, 0.0, 0.0, 0.0);
                    break;
                }
                case LIGHT: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
                    break;
                }
                case SOUL: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

