/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.HitBoxData;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ParticleHelper;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.ToolHelper;
import shetiphian.core.common.UseContext;
import shetiphian.platforms.Configuration;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.render.RenderRegistry;
import shetiphian.platforms.common.block.BlockPlatformFloor;
import shetiphian.platforms.common.block.BlockPlatformRamp;
import shetiphian.platforms.common.block.BlockPlatformType;
import shetiphian.platforms.common.block.PropertySubType;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFlat;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFloor;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFrame;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRamp;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRise;

public abstract class BlockPlatformBase
extends Block
implements EntityBlock,
IColored,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)3);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected final EnumPlatformType platformType;
    protected static Table<String, Direction, VoxelShape> HITBOXES = HashBasedTable.create();
    private static final Map<String, VoxelShape> BOXCACHE = new HashMap<String, VoxelShape>();
    private static final Material materialPlatform = new Material(MaterialColor.f_76411_, false, false, true, false, false, false, PushReaction.IGNORE);
    private static final Cache<Entity, BlockPos> WALK_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.SECONDS).build();

    public BlockPlatformBase(EnumPlatformType type) {
        super(BlockBehaviour.Properties.m_60939_((Material)materialPlatform).m_60918_(SoundType.f_56736_).m_60913_(3.0f, 0.5f).m_60977_().m_60955_());
        this.platformType = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LEVEL, WATERLOGGED});
        if (this.getPropertySubType() != null) {
            builder.m_61104_(new Property[]{this.getPropertySubType()});
        }
    }

    @Nullable
    protected abstract PropertySubType getPropertySubType();

    public EnumPlatformType getPlatformType() {
        return this.platformType;
    }

    public Collection<EnumSubType> getAllowedValues() {
        PropertySubType propertySubType = this.getPropertySubType();
        if (propertySubType == null) {
            return ImmutableSet.of((Object)((Object)EnumSubType.NONE));
        }
        return propertySubType.m_6908_();
    }

    public static EnumSubType getPlatformSubType(BlockState state) {
        BlockPlatformBase block;
        PropertySubType propertySubType;
        if (state.m_60734_() instanceof BlockPlatformBase && (propertySubType = (block = (BlockPlatformBase)state.m_60734_()).getPropertySubType()) != null) {
            return (EnumSubType)((Object)state.m_61143_((Property)propertySubType));
        }
        return EnumSubType.NONE;
    }

    public static BlockState getStateWithPlatformSubType(BlockState state, EnumSubType subType) {
        Collection subTypes;
        BlockPlatformBase block;
        PropertySubType propertySubType;
        if (subType != null && subType != EnumSubType.NONE && state.m_60734_() instanceof BlockPlatformBase && (propertySubType = (block = (BlockPlatformBase)state.m_60734_()).getPropertySubType()) != null && (subTypes = propertySubType.m_6908_()).contains((Object)subType)) {
            return (BlockState)state.m_61124_((Property)propertySubType, (Comparable)((Object)subType));
        }
        return state;
    }

    public static boolean setPlatformSubType(LevelAccessor world, BlockPos pos, EnumSubType subType) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof BlockPlatformBase) {
            BlockPlatformBase block = (BlockPlatformBase)state.m_60734_();
            BlockState result = BlockPlatformBase.getStateWithPlatformSubType(state, subType);
            if (result != state && Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)result, (boolean)true)) {
                TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
                if (tile instanceof TileEntityPlatformRamp) {
                    block.editLinkedRail(result, world, pos, tile, true);
                }
                if (tile instanceof TileEntityPlatformFloor) {
                    block.editLinkedRail(result, world, pos, tile, false);
                }
                return true;
            }
        }
        return false;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        switch (this.getPlatformType()) {
            case FLAT: {
                return new TileEntityPlatformFlat(pos, state);
            }
            case RAMP: {
                return new TileEntityPlatformRamp(pos, state);
            }
            case FLOOR: {
                return new TileEntityPlatformFloor(pos, state);
            }
            case FRAME: {
                return new TileEntityPlatformFrame(pos, state);
            }
            case RAIL: 
            case RISE: {
                return new TileEntityPlatformRise(pos, state);
            }
        }
        return null;
    }

    protected static TileEntityPlatformBase getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileEntityPlatformBase ? (TileEntityPlatformBase)tile : null;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        float value = state.m_60800_(world, pos);
        TileEntityPlatformBase tile = BlockPlatformBase.getTile(world, pos);
        if (tile != null) {
            try {
                Block block = ((BlockItem)tile.getFrameTextureBlock().m_41720_()).m_40614_();
                value = block.m_49966_().m_60800_(world, pos);
            }
            catch (Exception block) {
                // empty catch block
            }
        }
        int i = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) ? 30 : 100;
        return player.getDigSpeed(state, pos) / value / (float)i;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.platformType.isAddon();
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile != null) {
            return tile.getSoundType();
        }
        return super.m_49962_(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
        EnumPlatformType railType = TileHelper.getRail(BlockPlatformBase.getTile(world, pos));
        String linked = "";
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        String cacheKey = "collision:" + this.platformType.m_7912_() + ":" + subType.name() + ":" + direction.m_122433_();
        if (railType != null) {
            cacheKey = cacheKey + ":" + railType.m_7912_();
        }
        if (!BOXCACHE.containsKey(cacheKey)) {
            VoxelShape result = this.buildShape(subType, direction, railType, linked, true);
            if (result == null) {
                return Shapes.m_83040_();
            }
            BOXCACHE.put(cacheKey, result);
        }
        return BOXCACHE.get(cacheKey);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
        EnumPlatformType railType = TileHelper.getRail(BlockPlatformBase.getTile(world, pos));
        String linked = "";
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        String cacheKey = this.platformType.m_7912_() + ":" + subType.name() + ":" + direction.m_122433_();
        if (railType != null) {
            cacheKey = cacheKey + ":" + railType.m_7912_();
        }
        if (!BOXCACHE.containsKey(cacheKey)) {
            VoxelShape result = this.buildShape(subType, direction, railType, linked, false);
            if (result == null) {
                return Shapes.m_83144_();
            }
            BOXCACHE.put(cacheKey, result);
        }
        return BOXCACHE.get(cacheKey);
    }

    protected static void addHitBoxData(String key, double[][] cordsets) {
        Map map = HitBoxData.build((double[][])cordsets, (boolean)false);
        map.forEach((direction, shape) -> HITBOXES.put((Object)key, direction, shape));
    }

    protected VoxelShape buildShape(EnumSubType subType, Direction direction, EnumPlatformType railType, String linked, boolean collision) {
        return null;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.onDestroyedByPlayer(state, world, pos, player, false, fluid);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        TileEntityPlatformBase oTile;
        EnumTorchType torch;
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile instanceof TileEntityPlatformFrame && ((torch = ((TileEntityPlatformFrame)tile).getTorch()) == EnumTorchType.REDSTONE_ON || torch == EnumTorchType.LAMP_ON)) {
            world.m_46672_(pos, (Block)this);
            if (world.m_8055_(pos.m_7494_()).m_60734_() != this) {
                world.m_46672_(pos.m_7494_(), (Block)this);
            }
        }
        if (tile != null && (this.platformType == EnumPlatformType.RAMP || this.platformType == EnumPlatformType.FLOOR) && tile.hasRail()) {
            world.m_7471_(pos.m_7494_(), false);
        }
        if (tile instanceof TileEntityPlatformRise && ((TileEntityPlatformRise)tile).isLinked() && (oTile = BlockPlatformBase.getTile((BlockGetter)world, pos.m_7495_())) != null) {
            oTile.removeRail();
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity tile, ItemStack stack) {
        super.m_6240_(world, player, pos, state, tile, stack);
        world.m_7471_(pos, false);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List drops = super.m_7381_(state, builder);
        BlockEntity tile = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (tile instanceof TileEntityPlatformBase) {
            ((TileEntityPlatformBase)tile).addExtraDrops(drops);
        }
        return drops;
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (player == null || !player.m_6047_()) {
            return;
        }
        ItemStack currentItem = player.m_21205_();
        if (currentItem.m_41619_()) {
            return;
        }
        if (!ToolHelper.isWrench((ItemStack)currentItem)) {
            return;
        }
        if (this.platformType == EnumPlatformType.RAIL || this.platformType == EnumPlatformType.RISE) {
            return;
        }
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile == null || !TileHelper.hasRail(tile) && !TileHelper.hasTorch(tile)) {
            return;
        }
        ItemStack stack = null;
        if (this.platformType == EnumPlatformType.FRAME) {
            EnumTorchType torchType = TileHelper.getTorch(tile);
            stack = torchType != null ? torchType.getItemStack() : null;
        } else if (tile.hasRail()) {
            stack = tile.getRailItem();
        }
        if (stack != null) {
            Function.giveItem((Player)player, (ItemStack)stack);
            if (this.platformType == EnumPlatformType.FRAME) {
                TileHelper.removeTorch(tile);
                world.m_46672_(pos, (Block)this);
            } else {
                TileHelper.removeRail(tile);
                if (tile instanceof TileEntityPlatformRamp) {
                    this.editLinkedRail(state, (LevelAccessor)world, pos, tile, true);
                }
                if (tile instanceof TileEntityPlatformFloor) {
                    this.editLinkedRail(state, (LevelAccessor)world, pos, tile, false);
                }
            }
            Function.syncTile((BlockEntity)tile);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41619_()) {
            return InteractionResult.PASS;
        }
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile == null) {
            return InteractionResult.FAIL;
        }
        boolean isGlowstone = TagHelper.isItemInTag((ItemStack)heldItem, (String)"forge:dusts/glowstone");
        if (isGlowstone || EnumTorchType.isTorchItem(heldItem.m_41720_())) {
            if (this.platformType == EnumPlatformType.FRAME) {
                EnumTorchType torch;
                boolean placed = false;
                if (!TileHelper.hasTorch(tile) && !isGlowstone) {
                    if (heldItem.m_41720_() == Items.f_41978_) {
                        placed = TileHelper.setTorch(tile, this.isPowered((LevelReader)world, pos) ? EnumTorchType.REDSTONE_OFF : EnumTorchType.REDSTONE_ON);
                    } else if (heldItem.m_41720_() == Items.f_42000_) {
                        placed = TileHelper.setTorch(tile, EnumTorchType.LIGHT);
                    } else if (heldItem.m_41720_() == Items.f_42053_) {
                        placed = TileHelper.setTorch(tile, EnumTorchType.SOUL);
                    }
                } else if (isGlowstone && (torch = TileHelper.getTorch(tile)) != null) {
                    switch (torch) {
                        case REDSTONE_OFF: {
                            placed = TileHelper.setTorch(tile, EnumTorchType.LAMP_ON);
                            break;
                        }
                        case REDSTONE_ON: {
                            placed = TileHelper.setTorch(tile, EnumTorchType.LAMP_OFF);
                            break;
                        }
                        case LIGHT: {
                            placed = TileHelper.setTorch(tile, EnumTorchType.GLOWSTONE);
                            break;
                        }
                        case SOUL: {
                            placed = TileHelper.setTorch(tile, EnumTorchType.SOULSTONE);
                        }
                    }
                }
                if (placed) {
                    if (!player.m_150110_().f_35937_) {
                        heldItem.m_41774_(1);
                    }
                    world.m_5594_(player, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, world.f_46441_.nextFloat() * 0.1f + 0.9f);
                    world.m_46672_(pos, (Block)this);
                    if (world.m_8055_(pos.m_7494_()).m_60734_() != this) {
                        world.m_46672_(pos.m_7494_(), (Block)this);
                    }
                    Function.syncTile((BlockEntity)tile);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.FAIL;
        }
        if (heldItem.m_41720_() instanceof ItemBlockPlatform && ((ItemBlockPlatform)heldItem.m_41720_()).getPlatformType().isAddon() && BlockPlatformBase.canPlaceRailOn(state, (LevelReader)world, pos, tile) && TileHelper.setRail(tile, heldItem)) {
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            if (tile.hasRail()) {
                world.m_5594_(player, pos, tile.getRailSound().m_56777_(), SoundSource.BLOCKS, 1.0f, world.f_46441_.nextFloat() * 0.1f + 0.9f);
                Function.syncTile((BlockEntity)tile);
                if (tile instanceof TileEntityPlatformRamp) {
                    this.editLinkedRail(state, (LevelAccessor)world, pos, tile, true);
                }
                if (tile instanceof TileEntityPlatformFloor) {
                    this.editLinkedRail(state, (LevelAccessor)world, pos, tile, false);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if ((Integer)state.m_61143_((Property)LEVEL) > 0 && ToolHelper.isShovel((ItemStack)heldItem)) {
            int level = (Integer)state.m_61143_((Property)LEVEL);
            Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level - 1))), (boolean)true);
            tile.playLevelTextureSound(player, false);
            if (level <= 1) {
                tile.resetLevelTexture();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean canPlaceRailOn(BlockState state, LevelReader world, BlockPos pos, TileEntityPlatformBase tile) {
        if (!tile.hasRail() && state.m_60734_() instanceof BlockPlatformBase) {
            EnumPlatformType type = ((BlockPlatformBase)state.m_60734_()).platformType;
            EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
            if (tile instanceof TileEntityPlatformFlat || tile instanceof TileEntityPlatformFloor) {
                return subType.supportsRail(type);
            }
            if (tile instanceof TileEntityPlatformRamp && subType.supportsRail(type)) {
                BlockState stateUp = world.m_8055_(pos.m_7494_());
                return stateUp.m_60767_().m_76336_();
            }
        }
        return false;
    }

    private void editLinkedRail(BlockState state, LevelAccessor world, BlockPos pos, TileEntityPlatformBase tile, boolean isRamp) {
        if (state.m_60734_() instanceof BlockPlatformBase) {
            EnumPlatformType type = ((BlockPlatformBase)state.m_60734_()).platformType;
            EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
            BlockPos posUp = pos.m_7494_();
            BlockState above = world.m_8055_(posUp);
            if (subType.supportsRail(type) && tile.hasRail()) {
                TileEntityPlatformBase oTile;
                BlockState oState;
                if (above.m_60734_() != this && above.m_60767_().m_76336_()) {
                    EnumPlatformType platform = tile.getRailType();
                    if (platform == null) {
                        return;
                    }
                    Function.setBlock((LevelAccessor)world, (BlockPos)posUp, (BlockState)Values.blocksPlatform.get((Object)platform).m_49966_(), (boolean)false);
                }
                if ((oState = world.m_8055_(posUp)).m_60734_() instanceof BlockPlatformBase) {
                    oState = BlockPlatformBase.getStateWithPlatformSubType(oState, EnumSubType.byName(subType.getStyle()));
                    Function.setBlock((LevelAccessor)world, (BlockPos)posUp, (BlockState)((BlockState)oState.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))), (boolean)true);
                }
                if ((oTile = BlockPlatformBase.getTile((BlockGetter)world, posUp)) instanceof TileEntityPlatformRise) {
                    oTile.setTextureInfo(tile.getRailItem());
                    if (isRamp) {
                        ((TileEntityPlatformRise)oTile).setLinkedToRamp(true);
                    } else {
                        ((TileEntityPlatformRise)oTile).setLinkedToFloor(true);
                    }
                    Function.syncTile((BlockEntity)oTile);
                }
            } else {
                TileEntityPlatformBase oTile = BlockPlatformBase.getTile((BlockGetter)world, posUp);
                if (oTile instanceof TileEntityPlatformRise && ((TileEntityPlatformRise)oTile).isLinked()) {
                    world.m_7471_(posUp, false);
                }
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
        if (!(this instanceof BlockPlatformType.Singles)) {
            BlockState oState;
            boolean zAxis;
            EnumSubType subType = null;
            Direction face = context.m_43719_();
            boolean bl = zAxis = direction.m_122434_() == Direction.Axis.Z;
            if ((this instanceof BlockPlatformType.Walkways && face.m_122434_() != Direction.Axis.Y || this instanceof BlockPlatformType.Railings) && (oState = context.m_43725_().m_8055_(context.m_8083_().m_142300_(face.m_122424_()))).m_60734_() instanceof BlockPlatformBase) {
                BlockPlatformBase oBlock = (BlockPlatformBase)oState.m_60734_();
                if (oBlock.platformType == this.platformType) {
                    state = (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)oState.m_61143_((Property)FACING)));
                    subType = BlockPlatformBase.getPlatformSubType(oState);
                } else if (face == Direction.UP && this instanceof BlockPlatformType.Railings) {
                    subType = EnumSubType.byName(BlockPlatformBase.getPlatformSubType(oState).getStyle());
                    if (subType.supportsRail(oBlock.platformType)) {
                        state = (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)oState.m_61143_((Property)FACING)));
                    } else {
                        subType = null;
                    }
                }
            }
            if (subType == null) {
                boolean railOnStep = false;
                if (this instanceof BlockPlatformType.Railings) {
                    double hitX = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_();
                    double hitZ = context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_();
                    BlockState down = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
                    if (down.m_60734_() instanceof StairBlock) {
                        railOnStep = true;
                        direction = (Direction)down.m_61143_((Property)StairBlock.f_56841_);
                        subType = direction.m_122434_() == Direction.Axis.Z ? (direction == Direction.NORTH ? (hitX > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT) : (hitX > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT)) : (direction == Direction.EAST ? (hitZ > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT) : (hitZ > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT));
                    } else {
                        if (face.m_122434_() == Direction.Axis.Y) {
                            if (hitX <= 0.5 && hitZ < 0.5) {
                                direction = hitX < hitZ ? Direction.NORTH : Direction.EAST;
                            } else if (hitX > 0.5 && hitZ <= 0.5) {
                                direction = 1.0 - hitX < hitZ ? Direction.SOUTH : Direction.EAST;
                            } else if (hitX <= 0.5 && hitZ > 0.5) {
                                direction = hitX < 1.0 - hitZ ? Direction.NORTH : Direction.WEST;
                            } else if (hitX > 0.5 && hitZ >= 0.5) {
                                direction = hitX > hitZ ? Direction.SOUTH : Direction.WEST;
                            }
                        } else {
                            direction = face.m_122428_();
                        }
                        subType = EnumSubType.EDGE;
                    }
                    state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
                } else if (zAxis) {
                    double hitX = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_();
                    subType = hitX > (double)0.4f && hitX < (double)0.6f ? EnumSubType.MIDDLE : (direction == Direction.SOUTH ? (hitX > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT) : (hitX > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT));
                } else {
                    double hitZ = context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_();
                    if (hitZ > (double)0.4f && hitZ < (double)0.6f) {
                        subType = EnumSubType.MIDDLE;
                    } else if (direction == Direction.WEST) {
                        subType = hitZ > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT;
                    } else {
                        EnumSubType enumSubType = subType = hitZ > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT;
                    }
                }
                if (!railOnStep && this.platformType != EnumPlatformType.RAMP) {
                    if (subType == EnumSubType.RIGHT) {
                        state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_());
                        EnumSubType enumSubType = subType = this.platformType.isAddon() ? EnumSubType.EDGE : EnumSubType.EDGE_S;
                    }
                    if (subType == EnumSubType.LEFT) {
                        subType = EnumSubType.EDGE;
                    }
                }
            }
            state = BlockPlatformBase.getStateWithPlatformSubType(state, subType);
        }
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile != null) {
            tile.setTextureInfo(stack);
            Function.syncTile((BlockEntity)tile);
        }
        this.updateBlock(state, world, pos);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() == newState.m_60734_()) {
            this.updateBlock(newState, world, pos);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        super.m_7458_(state, world, pos, random);
        if (world.f_46443_ || !((Boolean)Configuration.DUST_COVERING.isEnvironmentReactive.get()).booleanValue() || !(state.m_60734_() instanceof BlockPlatformBase) || ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return;
        }
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile != null) {
            int level = (Integer)state.m_61143_((Property)LEVEL);
            Holder biomeRegistryEntry = world.m_204166_(pos);
            Biome biome = (Biome)biomeRegistryEntry.m_203334_();
            boolean canIncreaseLevel = this.canIncreaseLevel(tile, (Holder<Biome>)biomeRegistryEntry, level);
            if (world.m_46471_()) {
                switch (biome.m_47530_()) {
                    case NONE: {
                        if (!world.m_46470_() || !canIncreaseLevel || !this.getChance(world.f_46441_, (Integer)Configuration.DUST_COVERING.chanceSandStorm.get()) || !this.isSandBiome((Level)world, pos) || !this.isOutdoors((Level)world, pos, true)) break;
                        Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level + 1))), (boolean)true);
                        break;
                    }
                    case RAIN: {
                        if (biome.m_198906_(pos)) {
                            if (!world.m_46470_() || level <= 0 || !this.getChance(world.f_46441_, (Integer)Configuration.DUST_COVERING.chanceRainWash.get()) || !this.isSandBiome((Level)world, pos) || !this.isOutdoors((Level)world, pos, false)) break;
                            Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level - 1))), (boolean)true);
                            if (level > 1) break;
                            tile.resetLevelTexture();
                            break;
                        }
                    }
                    case SNOW: {
                        if (!canIncreaseLevel || !this.getChance(world.f_46441_, (Integer)Configuration.DUST_COVERING.chanceSnow.get()) || !this.isOutdoors((Level)world, pos, false)) break;
                        Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level + 1))), (boolean)true);
                    }
                }
            } else if (canIncreaseLevel && level == 0 && this.getChance(world.f_46441_, (Integer)Configuration.DUST_COVERING.chanceSand.get()) && this.isSandBiome((Level)world, pos) && this.isOutdoors((Level)world, pos, true)) {
                Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(1))), (boolean)true);
            }
        }
    }

    private boolean canIncreaseLevel(TileEntityPlatformBase tile, Holder<Biome> biomeRegistryEntry, int level) {
        if (level < 3) {
            Block layerTextureBlock = tile.getLayerTextureBlock();
            Block biomeLayerTexture = tile.getBiomeLayerTexture(biomeRegistryEntry);
            if (level == 0 && layerTextureBlock != biomeLayerTexture) {
                tile.resetLevelTexture();
                layerTextureBlock = tile.getLayerTextureBlock();
            }
            if (layerTextureBlock == Blocks.f_50016_) {
                return tile.setLevelTexture(new ItemStack((ItemLike)biomeLayerTexture));
            }
            return biomeLayerTexture == layerTextureBlock;
        }
        return false;
    }

    private boolean getChance(Random random, int odds) {
        return odds > 0 && random.nextInt(odds) == 0;
    }

    private boolean isSandBiome(Level world, BlockPos pos) {
        return BlockPlatformBase.getBiomeTopBlock((Holder<Biome>)world.m_204166_(pos)) instanceof SandBlock;
    }

    public static Block getBiomeTopBlock(Holder<Biome> biomeRegistryEntry) {
        return switch (Biome.m_204183_(biomeRegistryEntry)) {
            case Biome.BiomeCategory.MESA -> Blocks.f_49993_;
            case Biome.BiomeCategory.BEACH, Biome.BiomeCategory.DESERT -> Blocks.f_49992_;
            case Biome.BiomeCategory.UNDERGROUND, Biome.BiomeCategory.MOUNTAIN -> Blocks.f_49994_;
            case Biome.BiomeCategory.MUSHROOM -> Blocks.f_50195_;
            case Biome.BiomeCategory.ICY -> Blocks.f_50354_;
            case Biome.BiomeCategory.NETHER -> Blocks.f_50134_;
            case Biome.BiomeCategory.THEEND -> Blocks.f_50259_;
            case Biome.BiomeCategory.NONE -> Blocks.f_50069_;
            default -> Blocks.f_50440_;
        };
    }

    private boolean isOutdoors(Level world, BlockPos pos, boolean addingSand) {
        if (addingSand) {
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
            int layers = 0;
            boolean isRaining = world.m_46471_();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = -1; y <= 1; ++y) {
                        if (x == 0 && z == 0 && y == 0) continue;
                        mPos.m_122178_(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                        if (world.m_46859_((BlockPos)mPos)) continue;
                        BlockState state = world.m_8055_((BlockPos)mPos);
                        Block block = state.m_60734_();
                        if (block instanceof BlockPlatformBase) {
                            if (y < 0 && !isRaining) continue;
                            layers += Math.max(0, (Integer)state.m_61143_((Property)LEVEL) - 1);
                            continue;
                        }
                        if (!state.m_204336_(BlockTags.f_13029_)) continue;
                        return true;
                    }
                }
            }
            return layers > 3;
        }
        if (world.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()) <= pos.m_123342_() + 1) {
            return true;
        }
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                mPos.m_122178_(pos.m_123341_() + x, pos.m_123342_(), pos.m_123343_() + z);
                if (world.m_6924_(Heightmap.Types.MOTION_BLOCKING, mPos.m_123341_(), mPos.m_123343_()) > pos.m_123342_() + 1) continue;
                return true;
            }
        }
        return false;
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        BlockPos cached;
        TileEntityPlatformBase tile;
        super.m_141947_(world, pos, state, entity);
        if (!(world.f_46443_ || !((Boolean)Configuration.DUST_COVERING.isEntityReactive.get()).booleanValue() || (tile = BlockPlatformBase.getTile((BlockGetter)world, pos)) == null || (cached = (BlockPos)WALK_CACHE.getIfPresent((Object)entity)) != null && cached.equals((Object)pos))) {
            int level = (Integer)state.m_61143_((Property)LEVEL);
            if (level > 0 && world.m_5822_().nextInt(4) == 0) {
                Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level - 1))), (boolean)true);
                if (level <= 1) {
                    tile.resetLevelTexture();
                }
            }
            WALK_CACHE.put((Object)entity, (Object)pos);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
        this.updateBlock(state, world, pos);
    }

    private void updateBlock(BlockState state, Level world, BlockPos pos) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile == null) {
            return;
        }
        if (this.platformType == EnumPlatformType.RAMP) {
            BlockPos posForward;
            BlockState stateForward;
            AABB aabbDown;
            BlockState stateDown;
            Block blockDown;
            int altSupport = world.m_46859_(pos.m_7495_()) ? 2 : ((blockDown = (stateDown = world.m_8055_(pos.m_7495_())).m_60734_()) instanceof FenceBlock ? 1 : ((aabbDown = this.getShapeBoundingBox(stateDown.m_60808_((BlockGetter)world, pos.m_7495_()))) != null && aabbDown.f_82292_ >= 1.0 ? (aabbDown.f_82288_ > 0.0625 || aabbDown.f_82290_ > 0.0625 || aabbDown.f_82291_ < 0.9375 || aabbDown.f_82293_ < 0.9375 ? 1 : 0) : 2));
            if (!world.m_46859_(pos.m_142300_((Direction)state.m_61143_((Property)FACING))) && !(stateForward = world.m_8055_(posForward = pos.m_142300_((Direction)state.m_61143_((Property)FACING)))).m_60767_().m_76336_()) {
                AABB aabbForward = this.getShapeBoundingBox(stateForward.m_60808_((BlockGetter)world, posForward));
                AABB aabb = this.getShapeBoundingBox(state.m_60808_((BlockGetter)world, pos));
                altSupport += aabb != null && aabbForward != null && aabb.m_82338_(pos).m_82381_(aabbForward.m_82338_(posForward).m_82400_(0.1)) ? 3 : 0;
            }
            TileHelper.setAltSupport(tile, altSupport);
            if (tile instanceof TileEntityPlatformRamp) {
                boolean extLeft = false;
                boolean extRight = false;
                EnumSubType subType = (EnumSubType)((Object)state.m_61143_((Property)BlockPlatformType.Ramps.SUBTYPE));
                if (subType == EnumSubType.INSIDE) {
                    facing = (Direction)state.m_61143_((Property)FACING);
                    BlockState check = world.m_8055_(pos.m_142300_(facing.m_122428_()));
                    extLeft = BlockPlatformType.Ramps.isRamp(check) && ((Direction)check.m_61143_((Property)FACING)).equals((Object)facing) && ((EnumSubType)((Object)check.m_61143_((Property)BlockPlatformType.Ramps.SUBTYPE))).getBase().equals("normal");
                    check = world.m_8055_(pos.m_142300_(facing.m_122424_()));
                    extRight = BlockPlatformType.Ramps.isRamp(check) && ((Direction)check.m_61143_((Property)FACING)).equals((Object)facing.m_122427_()) && ((EnumSubType)((Object)check.m_61143_((Property)BlockPlatformType.Ramps.SUBTYPE))).getBase().equals("normal");
                } else if (subType == EnumSubType.OUTSIDE) {
                    facing = (Direction)state.m_61143_((Property)FACING);
                    BlockState check = world.m_8055_(pos.m_142300_(facing));
                    extLeft = BlockPlatformType.Ramps.isRamp(check) && ((Direction)check.m_61143_((Property)FACING)).equals((Object)facing.m_122427_()) && ((EnumSubType)((Object)check.m_61143_((Property)BlockPlatformType.Ramps.SUBTYPE))).getBase().equals("normal");
                    check = world.m_8055_(pos.m_142300_(facing.m_122427_()));
                    extRight = BlockPlatformType.Ramps.isRamp(check) && ((Direction)check.m_61143_((Property)FACING)).equals((Object)facing) && ((EnumSubType)((Object)check.m_61143_((Property)BlockPlatformType.Ramps.SUBTYPE))).getBase().equals("normal");
                }
                ((TileEntityPlatformRamp)tile).setSupportExtensions(extLeft, extRight);
            }
            Function.syncTile((BlockEntity)tile);
        } else if (this.platformType == EnumPlatformType.FLOOR) {
            AABB aabbDown;
            BlockState stateDown;
            Block blockDown;
            int altSupport = world.m_46859_(pos.m_7495_()) ? 2 : ((blockDown = (stateDown = world.m_8055_(pos.m_7495_())).m_60734_()) instanceof FenceBlock ? 1 : ((aabbDown = this.getShapeBoundingBox(stateDown.m_60808_((BlockGetter)world, pos.m_7495_()))) != null && aabbDown.f_82292_ >= 1.0 ? (aabbDown.f_82288_ > 0.0625 || aabbDown.f_82290_ > 0.0625 || aabbDown.f_82291_ < 0.9375 || aabbDown.f_82293_ < 0.9375 ? 1 : 0) : 2));
            TileHelper.setAltSupport(tile, altSupport);
            Function.syncTile((BlockEntity)tile);
        } else if (this.platformType == EnumPlatformType.FRAME) {
            if (TileHelper.hasTorch(tile)) {
                boolean notify = false;
                EnumTorchType torch = TileHelper.getTorch(tile);
                if (torch == EnumTorchType.REDSTONE_OFF || torch == EnumTorchType.REDSTONE_ON) {
                    if (this.isPowered((LevelReader)world, pos)) {
                        if (torch != EnumTorchType.REDSTONE_OFF) {
                            TileHelper.setTorch(tile, EnumTorchType.REDSTONE_OFF);
                            notify = true;
                            Function.syncTile((BlockEntity)tile);
                        }
                    } else if (torch != EnumTorchType.REDSTONE_ON) {
                        TileHelper.setTorch(tile, EnumTorchType.REDSTONE_ON);
                        notify = true;
                        Function.syncTile((BlockEntity)tile);
                    }
                } else if (torch == EnumTorchType.LAMP_OFF || torch == EnumTorchType.LAMP_ON) {
                    if (this.isPowered((LevelReader)world, pos)) {
                        if (torch != EnumTorchType.LAMP_ON) {
                            TileHelper.setTorch(tile, EnumTorchType.LAMP_ON);
                            notify = true;
                            Function.syncTile((BlockEntity)tile);
                        }
                    } else if (torch != EnumTorchType.LAMP_OFF) {
                        TileHelper.setTorch(tile, EnumTorchType.LAMP_OFF);
                        notify = true;
                        Function.syncTile((BlockEntity)tile);
                    }
                }
                if (notify) {
                    world.m_46672_(pos, (Block)this);
                    if (world.m_8055_(pos.m_7494_()).m_60734_() != this) {
                        world.m_46672_(pos.m_7494_(), (Block)this);
                    }
                }
            }
        } else if (this.platformType.isAddon()) {
            TileEntityPlatformBase oTile = BlockPlatformBase.getTile((BlockGetter)world, pos.m_7495_());
            if (tile instanceof TileEntityPlatformRise && ((TileEntityPlatformRise)tile).isLinkedToRamp() && !(oTile instanceof TileEntityPlatformRamp)) {
                world.m_7471_(pos, false);
            }
            if (tile instanceof TileEntityPlatformRise && ((TileEntityPlatformRise)tile).isLinkedToFloor() && !(oTile instanceof TileEntityPlatformFloor)) {
                world.m_7471_(pos, false);
            }
        }
    }

    private AABB getShapeBoundingBox(VoxelShape shape) {
        return shape.m_83281_() ? null : shape.m_83215_();
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return this.rotateBlock(state, world, pos, BlockPlatformBase.getTile((BlockGetter)world, pos), rotation);
    }

    public BlockState rotateBlock(BlockState state, LevelAccessor world, BlockPos pos, TileEntityPlatformBase tile, Rotation rotation) {
        if (tile == null) {
            return state;
        }
        if (tile instanceof TileEntityPlatformRise && ((TileEntityPlatformRise)tile).isLinked()) {
            BlockState newStateDown;
            BlockPos posDown = pos.m_7495_();
            BlockState stateDown = world.m_8055_(posDown);
            if ((stateDown.m_60734_() instanceof BlockPlatformFloor || stateDown.m_60734_() instanceof BlockPlatformRamp) && stateDown != (newStateDown = stateDown.rotate(world, posDown, rotation))) {
                Function.setBlock((LevelAccessor)world, (BlockPos)posDown, (BlockState)newStateDown, (boolean)true);
            }
            return world.m_8055_(pos);
        }
        if (this.platformType == EnumPlatformType.FRAME && rotation == Rotation.NONE) {
            rotation = Rotation.CLOCKWISE_90;
        }
        if (rotation != Rotation.NONE) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            switch (rotation) {
                case CLOCKWISE_90: {
                    direction = direction.m_122427_();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    direction = direction.m_122428_();
                    break;
                }
                case CLOCKWISE_180: {
                    direction = direction.m_122424_();
                }
            }
            BlockState rotatedState = (BlockState)state.m_61124_((Property)FACING, (Comparable)direction);
            if (tile.hasRail() && (tile instanceof TileEntityPlatformRamp || tile instanceof TileEntityPlatformFloor)) {
                this.editLinkedRail(rotatedState, world, pos, tile, tile instanceof TileEntityPlatformRamp);
            }
            return rotatedState;
        }
        EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
        PropertySubType propertySubType = this.getPropertySubType();
        if (propertySubType == null) {
            return state;
        }
        ArrayList<EnumSubType> subTypes = propertySubType.m_6908_();
        if (tile.hasRail() || this.platformType.isAddon()) {
            ArrayList<EnumSubType> railSupport = new ArrayList<EnumSubType>();
            for (EnumSubType type : subTypes) {
                switch (type.getStyleType()) {
                    case NONE: 
                    case MIDDLE: {
                        break;
                    }
                    case INSIDE: 
                    case OUTSIDE: 
                    case EDGE: {
                        if (tile instanceof TileEntityPlatformRamp) break;
                    }
                    default: {
                        railSupport.add(type);
                    }
                }
            }
            subTypes = railSupport;
        }
        EnumSubType newType = null;
        EnumSubType[] types = subTypes.toArray(new EnumSubType[0]);
        int current = 100;
        for (int index = 0; index < types.length; ++index) {
            if (types[index] == subType) {
                current = index;
            }
            if (current >= index) continue;
            newType = types[index];
            break;
        }
        if (newType == null && current > 0) {
            newType = types[0];
        }
        if (newType != null && BlockPlatformBase.setPlatformSubType(world, pos, newType)) {
            return world.m_8055_(pos);
        }
        return state;
    }

    private boolean isPowered(LevelReader world, BlockPos pos) {
        if (world.m_46852_(pos.m_7495_(), Direction.DOWN) > 0) {
            return true;
        }
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos.m_142300_(facing));
            if (TileHelper.hasTorch(tile) || world.m_46852_(pos.m_142300_(facing), facing) <= 1) continue;
            return true;
        }
        return false;
    }

    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side == Direction.DOWN ? this.m_6378_(state, world, pos, side) : 0;
    }

    public int m_6378_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        TileEntityPlatformBase tile;
        if (side != Direction.UP && this.platformType == EnumPlatformType.FRAME && (tile = BlockPlatformBase.getTile(world, pos)) != null) {
            EnumTorchType torch = TileHelper.getTorch(tile);
            return torch == EnumTorchType.REDSTONE_ON || torch == EnumTorchType.LAMP_ON ? (side == Direction.DOWN ? 15 : 1) : 0;
        }
        return 0;
    }

    public boolean addLandingEffects(BlockState state, ServerLevel world, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        BlockState particles;
        ItemStack stack;
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile != null && !(stack = tile.getCoverTextureBlock()).m_41619_() && stack.m_41720_() instanceof BlockItem && !(particles = UseContext.getBlockPlacementStateFor((ItemStack)stack, (Level)world)).m_60795_()) {
            return ParticleHelper.addLandingEffects((ServerLevel)world, (Entity)entity, (int)numberOfParticles, (BlockState)particles);
        }
        return false;
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockState particles;
        ItemStack stack;
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile != null && !(stack = tile.getCoverTextureBlock()).m_41619_() && stack.m_41720_() instanceof BlockItem && !(particles = UseContext.getBlockPlacementStateFor((ItemStack)stack, (Level)world)).m_60795_()) {
            return ParticleHelper.addRunningEffects((Level)world, (BlockPos)pos, (Entity)entity, (BlockState)particles);
        }
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityPlatformBase tile;
        if (index > 0 && index < 5 && data.world != null && data.pos != null && (tile = BlockPlatformBase.getTile((BlockGetter)data.world, data.pos)) != null) {
            if (this.platformType.isAddon()) {
                index -= 2;
            }
            return tile.getTint(index - 1);
        }
        return 0xFFFFFF;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile(world, pos);
        if (tile != null) {
            return ItemBlockPlatform.createStack(this, tile.getFrameTextureBlock(), tile.getCoverTextureBlock());
        }
        return new ItemStack((ItemLike)this);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile(world, pos);
        if (tile != null) {
            if (player.m_6047_() && TileHelper.hasRail(tile)) {
                return tile.getRailItem();
            }
            return ItemBlockPlatform.createStack(this, tile.getFrameTextureBlock(), tile.getCoverTextureBlock());
        }
        return new ItemStack((ItemLike)this);
    }
}

