/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import joptsimple.internal.Strings;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.client.model.AssembledBakedModel;
import shetiphian.core.client.model.CompositeBakedModel;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.UseContext;
import shetiphian.platforms.client.model.CacheBuilder;
import shetiphian.platforms.client.model.Parts;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.EnumTorchType;

@OnlyIn(value=Dist.CLIENT)
public class ModelPlatform {
    private static String getTextureForRenderLayer(ItemStack stack, RenderType layer) {
        boolean doRender;
        if (layer == null || stack.m_41619_()) {
            return Parts.getPlacementTexture();
        }
        BlockState materialState = UseContext.getBlockPlacementStateFor((ItemStack)stack);
        boolean bl = doRender = layer == RenderType.m_110451_();
        doRender = ItemBlockRenderTypes.canRenderInLayer((BlockState)materialState, (RenderType)RenderType.m_110466_()) ? layer == RenderType.m_110466_() : (ItemBlockRenderTypes.canRenderInLayer((BlockState)materialState, (RenderType)RenderType.m_110463_()) || ItemBlockRenderTypes.canRenderInLayer((BlockState)materialState, (RenderType)RenderType.m_110457_()) ? layer == RenderType.m_110463_() : doRender);
        return doRender ? CacheBuilder.INSTANCE.getTexture(stack) : null;
    }

    private static void addParts_Flat(List<BakedModel> list, EnumSubType subType, String[] textures, String particle, Direction facing, EnumPlatformType railType, Pair<String, String> levelData) {
        String base = subType.getBase();
        String style = subType.getStyle();
        String name = style + (base.equals("corner") ? "_corner" : "");
        ModelPlatform.add(list, "flat/base_" + base, textures[0], style.equals("inside") ? facing.m_122424_() : facing, particle);
        for (String part : subType.getParts()) {
            ModelPlatform.add(list, "flat/" + name + "_" + part, textures[1], facing, particle);
        }
        if (railType != null && !subType.getStyle().equals("middle")) {
            ModelPlatform.addParts_Rise(list, subType, new String[]{textures[2], textures[3]}, particle, facing, railType == EnumPlatformType.RAIL, false, levelData);
        }
        if (levelData != null) {
            ModelPlatform.add(list, "flat/" + (String)levelData.getLeft() + "_" + name, (String)levelData.getRight(), facing, (String)levelData.getRight());
        }
    }

    private static void addParts_Ramp(List<BakedModel> list, EnumSubType subType, String[] textures, String particle, Direction facing, EnumPlatformType railType, int support, Pair<String, String> levelData, Pair<Boolean, Boolean> supportExtensions) {
        ModelPlatform.add(list, "ramp/" + subType.getStyle(), textures[1], facing, particle);
        String base = subType.getBase().equals("normal") ? "normal" : subType.getBase() + "_" + subType.getStyle();
        ModelPlatform.add(list, "ramp/base_" + base, textures[0], facing, particle);
        ModelPlatform.add(list, "ramp/base_" + base + "_strut", textures[0], facing, particle);
        if (((Boolean)supportExtensions.getLeft()).booleanValue()) {
            ModelPlatform.add(list, "ramp/base_" + base + "_strut_ext_l", textures[0], facing, particle);
        }
        if (((Boolean)supportExtensions.getRight()).booleanValue()) {
            ModelPlatform.add(list, "ramp/base_" + base + "_strut_ext_r", textures[0], facing, particle);
        }
        if (support % 3 < 2) {
            ModelPlatform.add(list, "ramp/support_" + base + (support % 3 == 1 ? "_post" : "_legs"), textures[0], facing, particle);
        }
        if (support > 2) {
            String extra = subType.getStyle().equals("right") || subType.getStyle().equals("left") ? (support % 3 != 1 ? "_sb" : "_lb") : "";
            ModelPlatform.add(list, "ramp/support_beam_" + subType.getStyle() + extra, textures[0], facing, particle);
            ModelPlatform.add(list, "ramp/support_brace_" + subType.getStyle(), textures[0], facing, particle);
        }
        if (railType == EnumPlatformType.RAIL && subType.supportsRail(EnumPlatformType.RAMP)) {
            ModelPlatform.add(list, "ramp/rail_support_extension_" + subType.getStyle(), textures[2], facing, particle);
        }
        if (levelData != null) {
            ModelPlatform.add(list, "ramp/" + (String)levelData.getLeft() + "_" + subType.getStyle(), (String)levelData.getRight(), facing, (String)levelData.getRight());
        }
    }

    private static void addParts_Floor(List<BakedModel> list, EnumSubType subType, String[] textures, String particle, Direction facing, int support, Pair<String, String> levelData) {
        String base = subType.getBase();
        String style = subType.getStyle();
        String leg_base = base + "_" + style;
        String name = style + (base.equals("corner") ? "_corner" : "");
        ModelPlatform.add(list, "floor/base_" + leg_base, textures[0], style.equals("inside") ? facing.m_122424_() : facing, particle);
        for (String part : subType.getParts()) {
            ModelPlatform.add(list, "floor/" + name + "_" + part, textures[1], facing, particle);
        }
        if (support == 0) {
            ModelPlatform.add(list, "floor/support_legs", textures[0], facing, particle);
        } else if (support == 1) {
            if (!style.equals("middle")) {
                ModelPlatform.add(list, "floor/support_post_" + leg_base, textures[0], style.equals("inside") ? facing.m_122424_() : facing, particle);
            } else {
                ModelPlatform.add(list, "floor/support_post_extension", textures[0], facing, particle);
            }
        }
        if (levelData != null) {
            ModelPlatform.add(list, "floor/" + (String)levelData.getLeft() + "_" + name, (String)levelData.getRight(), facing, (String)levelData.getRight());
        }
    }

    private static void addParts_Rise(List<BakedModel> list, EnumSubType type, String[] textures, String particle, Direction facing, boolean isRail, boolean isLinkedToFloor, Pair<String, String> levelData) {
        if (!type.getStyle().equals("middle")) {
            String variant = isRail ? "rail" : "rise";
            String name = type.getStyle() + (type.getBase().equals("corner") ? "_corner" : "");
            if (name.equals("left") || name.equals("right")) {
                name = name + "_tall";
            }
            ModelPlatform.add(list, variant + "/bar_" + name, textures[1], facing, particle);
            ModelPlatform.add(list, variant + "/support_" + name + (isLinkedToFloor ? "_extended" : ""), textures[0], facing, particle);
            if (variant.equals("rise")) {
                ModelPlatform.add(list, variant + "/brace_" + name, textures[1], facing, particle);
            }
            if (levelData != null) {
                ModelPlatform.add(list, variant + "/" + (String)levelData.getLeft() + "_" + name, (String)levelData.getRight(), facing, (String)levelData.getRight());
            }
        }
    }

    private static void add(List<BakedModel> list, String part, String key, Direction facing, String particle) {
        BakedModel model;
        if (!Strings.isNullOrEmpty((String)key) && (model = CacheBuilder.get(part, key, facing, particle)) != null) {
            list.add(model);
        }
    }

    private static class ItemHandler {
        static ItemHandler INSTANCE = new ItemHandler();
        private static Map<EnumPlatformType, ItemTransforms> transforms = new HashMap<EnumPlatformType, ItemTransforms>();

        private ItemHandler() {
        }

        BakedModel getModel(ItemStack stack, BakedModel original) {
            if (!stack.m_41619_() && stack.m_41720_() instanceof ItemBlockPlatform) {
                EnumPlatformType platformType = ((ItemBlockPlatform)stack.m_41720_()).getPlatformType();
                if (!transforms.containsKey((Object)platformType)) {
                    transforms.put(platformType, this.buildTransforms(platformType));
                }
                String key1 = CacheBuilder.INSTANCE.getTexture(ItemBlockPlatform.getFrameTextureStack(stack));
                String key2 = CacheBuilder.INSTANCE.getTexture(ItemBlockPlatform.getCoverTextureStack(stack));
                EnumSubType subType = ItemBlockPlatform.getSubType(stack);
                ArrayList<BakedModel> list = new ArrayList<BakedModel>();
                switch (platformType) {
                    case FLAT: {
                        if (subType == EnumSubType.NONE) {
                            ModelPlatform.add(list, "flat/edge_north", key2, Direction.NORTH, key2);
                            ModelPlatform.add(list, "flat/base_normal", key1, Direction.NORTH, key2);
                            break;
                        }
                        ModelPlatform.addParts_Flat(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, null, null);
                        break;
                    }
                    case FLOOR: {
                        if (subType == EnumSubType.NONE) {
                            ModelPlatform.add(list, "floor/edge_north", key2, Direction.NORTH, key2);
                            ModelPlatform.add(list, "floor/base_normal_edge", key1, Direction.NORTH, key2);
                            break;
                        }
                        ModelPlatform.addParts_Floor(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, 0, null);
                        break;
                    }
                    case FRAME: {
                        ModelPlatform.add(list, "frame/bar", key2, Direction.NORTH, key2);
                        ModelPlatform.add(list, "frame/support", key1, Direction.NORTH, key2);
                        break;
                    }
                    case RAMP: {
                        if (subType == EnumSubType.NONE) {
                            ModelPlatform.add(list, "ramp/left", key2, Direction.NORTH, key2);
                            ModelPlatform.add(list, "ramp/base_normal", key1, Direction.NORTH, key2);
                            ModelPlatform.add(list, "ramp/base_normal_strut", key1, Direction.NORTH, key2);
                            ModelPlatform.add(list, "ramp/support_normal_post", key1, Direction.NORTH, key2);
                            break;
                        }
                        ModelPlatform.addParts_Ramp(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, null, 1, null, (Pair<Boolean, Boolean>)Pair.of((Object)false, (Object)false));
                        break;
                    }
                    case RISE: {
                        if (subType == EnumSubType.NONE) {
                            ModelPlatform.add(list, "rise/bar_edge", key2, Direction.NORTH, key2);
                            ModelPlatform.add(list, "rise/support_edge", key1, Direction.NORTH, key2);
                            break;
                        }
                        ModelPlatform.addParts_Rise(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, false, false, null);
                        break;
                    }
                    case RAIL: {
                        if (subType == EnumSubType.NONE) {
                            ModelPlatform.add(list, "rail/bar_edge", key2, Direction.NORTH, key2);
                            ModelPlatform.add(list, "rail/support_edge", key1, Direction.NORTH, key2);
                            break;
                        }
                        ModelPlatform.addParts_Rise(list, subType, new String[]{key1, key2}, key2, Direction.NORTH, true, false, null);
                    }
                }
                return new AssembledBakedModel(list, new ItemTransforms[]{transforms.get((Object)platformType)});
            }
            return original;
        }

        private ItemTransforms buildTransforms(EnumPlatformType platformType) {
            switch (platformType) {
                case FLAT: {
                    return this.getFlatTransforms();
                }
                case FLOOR: {
                    return this.getFloorTransforms();
                }
                case FRAME: {
                    return this.getFrameTransforms();
                }
                case RAMP: {
                    return this.getRampTransforms();
                }
                case RISE: {
                    return this.getRiseTransforms();
                }
                case RAIL: {
                    return this.getRailTransforms();
                }
            }
            return ItemTransforms.f_111786_;
        }

        private ItemTransforms getFlatTransforms() {
            ItemTransform thirdperson_left = this.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 3.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform thirdperson_right = this.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 3.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson_left = this.create(0.0f, 135.0f, 0.0f, 0.0f, 5.25f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform firstperson_right = this.create(0.0f, 135.0f, 0.0f, 0.0f, 5.25f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform gui = this.create(30.0f, 315.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform fixed = this.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private ItemTransforms getRampTransforms() {
            ItemTransform thirdperson_left = this.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform thirdperson_right = this.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson_left = this.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform firstperson_right = this.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform gui = this.create(30.0f, 315.0f, 0.0f, 0.0f, 0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform fixed = this.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private ItemTransforms getFloorTransforms() {
            ItemTransform thirdperson_left = this.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform thirdperson_right = this.create(75.0f, 315.0f, 0.0f, 0.0f, 2.5f, 2.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson_left = this.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform firstperson_right = this.create(0.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform gui = this.create(30.0f, 315.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform fixed = this.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private ItemTransforms getFrameTransforms() {
            ItemTransform thirdperson_left = this.create(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform thirdperson_right = this.create(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson_left = this.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform firstperson_right = this.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform gui = this.create(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform fixed = this.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            return new ItemTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private ItemTransforms getRiseTransforms() {
            ItemTransform thirdperson_left = this.create(75.0f, 45.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform thirdperson_right = this.create(75.0f, 225.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson_left = this.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform firstperson_right = this.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform gui = this.create(30.0f, 315.0f, 0.0f, 0.75f, -0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform fixed = this.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, -2.75f, 0.5f, 0.5f, 0.5f);
            return new ItemTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private ItemTransforms getRailTransforms() {
            ItemTransform thirdperson_left = this.create(75.0f, 45.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform thirdperson_right = this.create(75.0f, 225.0f, 0.0f, -3.5f, 0.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson_left = this.create(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform firstperson_right = this.create(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform gui = this.create(30.0f, 315.0f, 0.0f, 0.75f, -0.75f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform fixed = this.create(0.0f, 90.0f, 0.0f, 0.0f, 0.0f, -2.75f, 0.5f, 0.5f, 0.5f);
            return new ItemTransforms(thirdperson_left, thirdperson_right, firstperson_left, firstperson_right, head, gui, ground, fixed);
        }

        private ItemTransform create(float rX, float rY, float rZ, float tX, float tY, float tZ, float sX, float sY, float sZ) {
            Vector3f rotation = new Vector3f(rX, rY, rZ);
            Vector3f translation = new Vector3f(tX, tY, tZ);
            translation.m_122261_(0.0625f);
            translation.m_122242_(-5.0f, 5.0f);
            Vector3f scale = new Vector3f(sX, sY, sZ);
            scale.m_122242_(-4.0f, 4.0f);
            return new ItemTransform(rotation, translation, scale);
        }
    }

    private static class BlockHandler {
        static BlockHandler INSTANCE = new BlockHandler();

        private BlockHandler() {
        }

        List<BakedModel> getList(BlockState state, IModelData data, RenderType layer) {
            ArrayList<BakedModel> list = new ArrayList<BakedModel>();
            if (state.m_60734_() instanceof BlockPlatformBase) {
                CompoundTag nbtTag;
                EnumPlatformType platformType = ((BlockPlatformBase)state.m_60734_()).getPlatformType();
                Direction facing = (Direction)state.m_61143_((Property)BlockPlatformBase.FACING);
                int level = (Integer)state.m_61143_((Property)BlockPlatformBase.LEVEL);
                EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
                ItemStack itemBaseFrame = ItemStack.f_41583_;
                ItemStack itemBaseCover = ItemStack.f_41583_;
                EnumPlatformType railType = null;
                ItemStack itemRailFrame = ItemStack.f_41583_;
                ItemStack itemRailCover = ItemStack.f_41583_;
                EnumTorchType torch = EnumTorchType.NONE;
                byte support = 0;
                boolean linkedToFloor = false;
                Pair levelData = null;
                Pair supportExtensions = Pair.of((Object)false, (Object)false);
                if (data.hasProperty(ModelProperties.NBTProperty) && (nbtTag = (CompoundTag)data.getData(ModelProperties.NBTProperty)) != null) {
                    ItemBlockPlatform platform;
                    ItemStack itemRail;
                    if (nbtTag.m_128441_("frame_texture_item")) {
                        itemBaseFrame = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("frame_texture_item"));
                    }
                    if (nbtTag.m_128441_("cover_texture_item")) {
                        itemBaseCover = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("cover_texture_item"));
                    }
                    if (nbtTag.m_128441_("rail_item") && !(itemRail = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("rail_item"))).m_41619_() && itemRail.m_41720_() instanceof ItemBlockPlatform && (platform = (ItemBlockPlatform)itemRail.m_41720_()).getPlatformType().isAddon()) {
                        railType = platform.getPlatformType();
                        itemRailFrame = ItemBlockPlatform.getFrameTextureStack(itemRail);
                        itemRailCover = ItemBlockPlatform.getCoverTextureStack(itemRail);
                    }
                    if (nbtTag.m_128441_("torch")) {
                        torch = EnumTorchType.byIndex(nbtTag.m_128445_("torch"));
                    }
                    if (nbtTag.m_128441_("support")) {
                        support = nbtTag.m_128445_("support");
                    }
                    if (nbtTag.m_128441_("linkedToFloor")) {
                        linkedToFloor = nbtTag.m_128471_("linkedToFloor");
                    }
                    if (level > 0 && nbtTag.m_128441_("layer_texture_item")) {
                        String texture = ModelPlatform.getTextureForRenderLayer(ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("layer_texture_item")), layer);
                        String variant = "cover_lvl" + level;
                        levelData = Pair.of((Object)variant, (Object)texture);
                    }
                    if (nbtTag.m_128441_("support_ext_left") && nbtTag.m_128441_("support_ext_right")) {
                        supportExtensions = Pair.of((Object)nbtTag.m_128471_("support_ext_left"), (Object)nbtTag.m_128471_("support_ext_right"));
                    }
                }
                String particle = CacheBuilder.INSTANCE.getTexture(itemBaseCover);
                String[] textures = new String[4];
                textures[0] = ModelPlatform.getTextureForRenderLayer(itemBaseFrame, layer);
                textures[1] = ModelPlatform.getTextureForRenderLayer(itemBaseCover, layer);
                if (railType != null) {
                    textures[2] = ModelPlatform.getTextureForRenderLayer(itemRailFrame, layer);
                    textures[3] = ModelPlatform.getTextureForRenderLayer(itemRailCover, layer);
                }
                switch (platformType) {
                    case FLAT: {
                        ModelPlatform.addParts_Flat(list, subType, textures, particle, facing, railType, levelData);
                        break;
                    }
                    case FLOOR: {
                        ModelPlatform.addParts_Floor(list, subType, textures, particle, facing, support, levelData);
                        break;
                    }
                    case FRAME: {
                        ModelPlatform.add(list, "frame/bar", textures[1], facing, particle);
                        ModelPlatform.add(list, "frame/support", textures[0], facing, particle);
                        if (torch != null && torch != EnumTorchType.NONE && layer == RenderType.m_110451_()) {
                            ModelPlatform.add(list, "frame/brazier_base", Parts.getBrazierTexture(), facing, particle);
                            ModelPlatform.add(list, "frame/brazier_fill", Parts.getBrazierFillTexture(torch), facing, particle);
                        }
                        if (levelData == null) break;
                        ModelPlatform.add(list, "frame/" + (String)levelData.getLeft(), (String)levelData.getRight(), facing, (String)levelData.getRight());
                        break;
                    }
                    case RAMP: {
                        ModelPlatform.addParts_Ramp(list, subType, textures, particle, facing, railType, support, levelData, (Pair<Boolean, Boolean>)supportExtensions);
                        break;
                    }
                    case RISE: {
                        ModelPlatform.addParts_Rise(list, subType, textures, particle, facing, false, linkedToFloor, levelData);
                        break;
                    }
                    case RAIL: {
                        ModelPlatform.addParts_Rise(list, subType, textures, particle, facing, true, linkedToFloor, levelData);
                    }
                }
            }
            return list;
        }
    }

    public static class Baked
    extends CompositeBakedModel {
        public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
            CompoundTag nbtTag;
            ItemStack materialItem = ItemStack.f_41583_;
            if (data.hasProperty(ModelProperties.NBTProperty) && (nbtTag = (CompoundTag)data.getData(ModelProperties.NBTProperty)) != null && nbtTag.m_128441_("cover_texture_item")) {
                materialItem = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("cover_texture_item"));
            }
            if (materialItem.m_41619_()) {
                materialItem = new ItemStack((ItemLike)Blocks.f_50058_);
            }
            return CacheBuilder.INSTANCE.getTextureSprite(materialItem);
        }

        protected List<BakedModel> handleBlockState(BlockState state, Direction side, Random rand, IModelData data) {
            return BlockHandler.INSTANCE.getList(state, data, MinecraftForgeClient.getRenderType());
        }

        protected BakedModel handleItemState(BakedModel model, ItemStack stack, Level world, LivingEntity entity) {
            return ItemHandler.INSTANCE.getModel(stack, model);
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry> {
        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<com.mojang.datafixers.util.Pair<String, String>> missingTextureErrors) {
            ArrayList<Material> list = new ArrayList<Material>();
            for (ResourceLocation location : Parts.TEXTURES) {
                list.add(new Material(TextureAtlas.f_118259_, location));
            }
            return ImmutableList.copyOf(list);
        }

        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            CacheBuilder.INSTANCE.preBakeSetup(bakery, spriteGetter);
            return new Baked();
        }
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public void m_6213_(ResourceManager resourceManager) {
            CacheBuilder.rebuildCache();
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new Geometry();
        }
    }
}

