/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.item;

import com.blakebr0.cucumber.energy.EnergyCapabilityProvider;
import com.blakebr0.cucumber.energy.ItemEnergyStorage;
import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.cucumber.item.BaseArmorItem;
import com.blakebr0.cucumber.lib.Tooltips;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.ironjetpacks.client.ModelHandler;
import com.blakebr0.ironjetpacks.client.model.JetpackModel;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.handler.InputHandler;
import com.blakebr0.ironjetpacks.lib.ModArmorMaterial;
import com.blakebr0.ironjetpacks.lib.ModTooltips;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public class JetpackItem
extends BaseArmorItem
implements IColored,
DyeableLeatherItem {
    public JetpackItem(Function<Item.Properties, Item.Properties> properties) {
        super((ArmorMaterial)ModArmorMaterial.JETPACK, EquipmentSlot.CHEST, properties.compose(Item.Properties::setNoRepair));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            JetpackRegistry.getInstance().getJetpacks().forEach(jetpack -> items.add((Object)JetpackUtils.getItemForJetpack(jetpack)));
        }
    }

    public Component m_7626_(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return Localizable.of((String)"item.ironjetpacks.jetpack").args(new Object[]{jetpack.displayName}).build();
    }

    public String m_5671_(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return Localizable.of((String)"item.ironjetpacks.jetpack").args(new Object[]{jetpack.displayName}).buildString();
    }

    public Rarity m_41460_(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        if (!stack.m_41793_()) {
            return jetpack.rarity;
        }
        return switch (jetpack.rarity) {
            default -> throw new IncompatibleClassChangeError();
            case Rarity.COMMON, Rarity.UNCOMMON -> Rarity.RARE;
            case Rarity.RARE -> Rarity.EPIC;
            case Rarity.EPIC -> jetpack.rarity;
        };
    }

    public int getItemEnchantability(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return jetpack.enchantablilty;
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        ItemStack chest = JetpackUtils.getEquippedJetpack(player);
        Item item = chest.m_41720_();
        if (!chest.m_41619_() && item instanceof JetpackItem && JetpackUtils.isEngineOn(chest)) {
            boolean hover = JetpackUtils.isHovering(chest);
            if (InputHandler.isHoldingUp(player) || hover && !player.m_20096_()) {
                Jetpack jetpack = JetpackUtils.getJetpack(stack);
                double motionY = player.m_20184_().m_7098_();
                double hoverSpeed = InputHandler.isHoldingDown(player) ? jetpack.speedHoverDescend : jetpack.speedHoverSlow;
                double currentAccel = jetpack.accelVert * (motionY < 0.3 ? 2.5 : 1.0);
                double currentSpeedVertical = jetpack.speedVert * (player.m_20069_() ? 0.4 : 1.0);
                double usage = player.m_20142_() || InputHandler.isHoldingSprint(player) ? (double)jetpack.usage * jetpack.sprintFuel : (double)jetpack.usage;
                boolean creative = jetpack.creative;
                IEnergyStorage energy = JetpackUtils.getEnergyStorage(chest);
                if (!player.m_7500_() && !creative) {
                    energy.extractEnergy((int)usage, false);
                }
                if (energy.getEnergyStored() > 0 || player.m_7500_() || creative) {
                    double verticalSprintMulti;
                    double throttle = JetpackUtils.getThrottle(stack);
                    double d = verticalSprintMulti = motionY >= 0.0 && InputHandler.isHoldingSprint(player) ? jetpack.sprintSpeedVert : 1.0;
                    if (InputHandler.isHoldingUp(player)) {
                        if (!hover) {
                            JetpackItem.fly(player, Math.min(motionY + currentAccel, currentSpeedVertical) * throttle * verticalSprintMulti);
                        } else if (InputHandler.isHoldingDown(player)) {
                            JetpackItem.fly(player, Math.min(motionY + currentAccel, -jetpack.speedHoverSlow) * throttle);
                        } else {
                            JetpackItem.fly(player, Math.min(motionY + currentAccel, jetpack.speedHoverAscend) * throttle * verticalSprintMulti);
                        }
                    } else {
                        JetpackItem.fly(player, Math.min(motionY + currentAccel, -hoverSpeed) * throttle);
                    }
                    double speedSideways = (player.m_6047_() ? jetpack.speedSide * 0.5 : jetpack.speedSide) * throttle;
                    double speedForward = (player.m_20142_() ? speedSideways * jetpack.sprintSpeed : speedSideways) * throttle;
                    if (InputHandler.isHoldingForwards(player)) {
                        player.m_19920_(1.0f, new Vec3(0.0, 0.0, speedForward));
                    }
                    if (InputHandler.isHoldingBackwards(player)) {
                        player.m_19920_(1.0f, new Vec3(0.0, 0.0, -speedSideways * (double)0.8f));
                    }
                    if (InputHandler.isHoldingLeft(player)) {
                        player.m_19920_(1.0f, new Vec3(speedSideways, 0.0, 0.0));
                    }
                    if (InputHandler.isHoldingRight(player)) {
                        player.m_19920_(1.0f, new Vec3(-speedSideways, 0.0, 0.0));
                    }
                    if (!level.m_5776_()) {
                        player.f_19789_ = 0.0f;
                        if (player instanceof ServerPlayer) {
                            ((ServerPlayer)player).f_8906_.f_9737_ = 0;
                        }
                    }
                }
            }
        }
    }

    public boolean m_8120_(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return (Boolean)ModConfigs.ENCHANTABLE_JETPACKS.get() != false && jetpack.enchantablilty > 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return (Boolean)ModConfigs.ENCHANTABLE_JETPACKS.get() != false && jetpack.enchantablilty > 0;
    }

    public int m_142158_(ItemStack stack) {
        IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
        int stored = energy.getMaxEnergyStored() - energy.getEnergyStored();
        return Math.round(13.0f - (float)stored * 13.0f / (float)energy.getMaxEnergyStored());
    }

    public int m_142159_(ItemStack stack) {
        IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
        float f = Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_142522_(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return !jetpack.creative;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        if (flag.m_7050_()) {
            tooltip.add((Component)ModTooltips.JETPACK_ID.args(new Object[]{jetpack.getId()}).color(ChatFormatting.DARK_GRAY).build());
            tooltip.add((Component)new TextComponent(" "));
        }
        if (!jetpack.creative) {
            IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
            tooltip.add((Component)new TextComponent(Utils.format((Object)energy.getEnergyStored()) + " / " + Utils.format((Object)energy.getMaxEnergyStored()) + " FE").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)ModTooltips.INFINITE.build().m_130946_(" FE"));
        }
        MutableComponent tier = ModTooltips.TIER.color(jetpack.rarity.f_43022_).args(new Object[]{jetpack.creative ? "C" : Integer.valueOf(jetpack.tier)}).build();
        MutableComponent engine = ModTooltips.ENGINE.color(JetpackUtils.isEngineOn(stack) ? ChatFormatting.GREEN : ChatFormatting.RED).build();
        MutableComponent hover = ModTooltips.HOVER.color(JetpackUtils.isHovering(stack) ? ChatFormatting.GREEN : ChatFormatting.RED).build();
        tooltip.add((Component)ModTooltips.STATE_TOOLTIP_LAYOUT.args(new Object[]{tier, engine, hover}).build());
        TextComponent throttle = new TextComponent((int)(JetpackUtils.getThrottle(stack) * 100.0) + "%");
        tooltip.add((Component)ModTooltips.THROTTLE.args(new Object[]{throttle}).build());
        if (((Boolean)ModConfigs.ENABLE_ADVANCED_INFO_TOOLTIPS.get()).booleanValue()) {
            tooltip.add((Component)new TextComponent(" "));
            if (!Screen.m_96638_()) {
                tooltip.add((Component)Tooltips.HOLD_SHIFT_FOR_INFO.build());
            } else {
                tooltip.add((Component)ModTooltips.FUEL_USAGE.args(new Object[]{jetpack.usage + " FE/t"}).build());
                tooltip.add((Component)ModTooltips.VERTICAL_SPEED.args(new Object[]{jetpack.speedVert}).build());
                tooltip.add((Component)ModTooltips.VERTICAL_ACCELERATION.args(new Object[]{jetpack.accelVert}).build());
                tooltip.add((Component)ModTooltips.HORIZONTAL_SPEED.args(new Object[]{jetpack.speedSide}).build());
                tooltip.add((Component)ModTooltips.HOVER_SPEED.args(new Object[]{jetpack.speedHoverSlow}).build());
                tooltip.add((Component)ModTooltips.HOVER_ASCEND_SPEED.args(new Object[]{jetpack.speedHoverAscend}).build());
                tooltip.add((Component)ModTooltips.HOVER_DESCEND_SPEED.args(new Object[]{jetpack.speedHoverDescend}).build());
                tooltip.add((Component)ModTooltips.SPRINT_MODIFIER.args(new Object[]{jetpack.sprintSpeed}).build());
                tooltip.add((Component)ModTooltips.SPRINT_VERTICAL_MODIFIER.args(new Object[]{jetpack.sprintSpeedVert}).build());
                tooltip.add((Component)ModTooltips.SPRINT_FUEL_MODIFIER.args(new Object[]{jetpack.sprintFuel}).build());
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.CHEST) {
            Jetpack jetpack = JetpackUtils.getJetpack(stack);
            return jetpack.attributeModifiers;
        }
        return ImmutableMultimap.of();
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(ItemRenderProperties.INSTANCE);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return type == null ? "ironjetpacks:textures/armor/jetpack.png" : "ironjetpacks:textures/armor/jetpack_overlay.png";
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return new EnergyCapabilityProvider((IEnergyStorage)new ItemEnergyStorage(stack, jetpack.capacity));
    }

    public int getColor(int i, ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return i == 1 ? jetpack.color : -1;
    }

    public boolean m_41113_(ItemStack stack) {
        return true;
    }

    public int m_41121_(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return jetpack.color;
    }

    public void m_41123_(ItemStack stack) {
    }

    public void m_41115_(ItemStack stack, int color) {
    }

    private static void fly(Player player, double y) {
        Vec3 motion = player.m_20184_();
        player.m_20334_(motion.m_7096_(), y, motion.m_7094_());
    }

    static class ItemRenderProperties
    implements IItemRenderProperties {
        public static final ItemRenderProperties INSTANCE = new ItemRenderProperties();
        private JetpackModel[] models;

        ItemRenderProperties() {
        }

        public HumanoidModel<?> getArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> _default) {
            if (this.models == null) {
                this.models = new JetpackModel[6];
                for (int i = 0; i < 6; ++i) {
                    ModelPart layer = Minecraft.m_91087_().m_167973_().m_171103_(ModelHandler.JETPACK_LAYER);
                    this.models[i] = new JetpackModel(layer, i);
                }
            }
            Jetpack jetpack = JetpackUtils.getJetpack(stack);
            if (jetpack.creative) {
                return this.models[5];
            }
            IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
            double stored = (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored();
            int state = 0;
            if (stored > 0.8) {
                state = 5;
            } else if (stored > 0.6) {
                state = 4;
            } else if (stored > 0.4) {
                state = 3;
            } else if (stored > 0.2) {
                state = 2;
            } else if (stored > 0.0) {
                state = 1;
            }
            return this.models[state];
        }
    }
}

