/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HomeCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"home").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommands.home(((CommandSourceStack)context.getSource()).m_81375_(), "home"))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(HomeCommands.getHomeSuggestions((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).executes(context -> HomeCommands.home(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sethome").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommands.sethome(((CommandSourceStack)context.getSource()).m_81375_(), "home"))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> HomeCommands.sethome(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"delhome").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommands.delhome(((CommandSourceStack)context.getSource()).m_81375_(), "home"))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(HomeCommands.getHomeSuggestions((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).executes(context -> HomeCommands.delhome(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"listhomes").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommands.listhomes((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_().m_36316_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).requires(source -> source.m_81377_().m_129792_() || source.m_6761_(2))).executes(context -> HomeCommands.listhomes((CommandSourceStack)context.getSource(), (GameProfile)GameProfileArgument.m_94590_((CommandContext)context, (String)"player").iterator().next()))));
    }

    public static Set<String> getHomeSuggestions(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        FTBEPlayerData data = FTBEPlayerData.get((Player)((CommandSourceStack)context.getSource()).m_81375_());
        if (data == null) {
            return Collections.emptySet();
        }
        return data.homes.keySet();
    }

    public static int home(ServerPlayer player, String name) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        if (data == null) {
            return 0;
        }
        TeleportPos pos = data.homes.get(name.toLowerCase());
        if (pos == null) {
            player.m_5661_((Component)new TextComponent("Home not found!"), false);
            return 0;
        }
        return data.homeTeleporter.teleport(player, p -> pos).runCommand(player);
    }

    public static int sethome(ServerPlayer player, String name) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        if (data == null) {
            return 0;
        }
        if (data.homes.size() >= FTBEConfig.MAX_HOMES.get(player) && !data.homes.containsKey(name.toLowerCase())) {
            player.m_5661_((Component)new TextComponent("Can't add any more homes!"), false);
            return 0;
        }
        data.homes.put(name.toLowerCase(), new TeleportPos((Entity)player));
        data.save();
        player.m_5661_((Component)new TextComponent("Home set!"), false);
        return 1;
    }

    public static int delhome(ServerPlayer player, String name) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        if (data == null) {
            return 0;
        }
        if (data.homes.remove(name.toLowerCase()) != null) {
            data.save();
            player.m_5661_((Component)new TextComponent("Home deleted!"), false);
            return 1;
        }
        player.m_5661_((Component)new TextComponent("Home not found!"), false);
        return 0;
    }

    public static int listhomes(CommandSourceStack source, GameProfile of) {
        FTBEPlayerData data = FTBEPlayerData.get(of);
        if (data == null) {
            return 0;
        }
        if (data.homes.isEmpty()) {
            source.m_81354_((Component)new TextComponent("None"), false);
            return 1;
        }
        TeleportPos origin = new TeleportPos((ResourceKey<Level>)source.m_81372_().m_46472_(), new BlockPos(source.m_81371_()));
        for (Map.Entry<String, TeleportPos> entry : data.homes.entrySet()) {
            source.m_81354_((Component)new TextComponent(entry.getKey() + ": " + entry.getValue().distanceString(origin)), false);
        }
        return 1;
    }
}

