/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbessentials.FTBEssentials;
import dev.ftb.mods.ftbessentials.command.FTBEssentialsCommands;
import dev.ftb.mods.ftbessentials.command.TPACommands;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Path;
import java.util.Iterator;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ftbessentials", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FTBEEventHandler {
    public static final LevelResource CONFIG_FILE = new LevelResource("serverconfig/ftbessentials.snbt");
    public static final Style RECORDING_STYLE = Style.f_131099_.m_131157_(ChatFormatting.RED);
    public static final Style STREAMING_STYLE = Style.f_131099_.m_131148_(TextColor.m_131266_((int)9520895));

    @SubscribeEvent
    public static void serverAboutToStart(ServerAboutToStartEvent event) {
        Path configFilePath = event.getServer().m_129843_(CONFIG_FILE);
        Path defaultConfigFilePath = Platform.getConfigFolder().resolve("../defaultconfigs/ftbessentials-server.snbt");
        FTBEConfig.CONFIG.load(configFilePath, defaultConfigFilePath, () -> new String[]{"Default config file that will be copied to world's serverconfig/ftbessentials.snbt location", "Copy values you wish to override in here", "Example:", "", "{", "\tmisc: {", "\t\tenderchest: {", "\t\t\tenabled: false", "\t\t}", "\t}", "}"});
        FTBEPlayerData.MAP.clear();
        FTBEWorldData.instance = new FTBEWorldData(event.getServer());
        try {
            SNBTCompoundTag tag = SNBT.read((Path)FTBEWorldData.instance.mkdirs("").resolve("data.snbt"));
            if (tag != null) {
                FTBEWorldData.instance.read(tag);
            }
        }
        catch (Exception ex) {
            FTBEssentials.LOGGER.error("Failed to load world data: " + ex);
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void serverStopped(ServerStoppedEvent event) {
        FTBEWorldData.instance = null;
        TPACommands.REQUESTS.clear();
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        FTBEssentialsCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void worldSaved(WorldEvent.Save event) {
        if (FTBEWorldData.instance != null && FTBEWorldData.instance.save && SNBT.write((Path)FTBEWorldData.instance.mkdirs("").resolve("data.snbt"), (CompoundTag)FTBEWorldData.instance.write())) {
            FTBEWorldData.instance.save = false;
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        FTBEPlayerData data = FTBEPlayerData.get(event.getPlayer());
        if (data == null) {
            return;
        }
        data.lastSeen = new TeleportPos((Entity)event.getPlayer());
        data.save();
        for (FTBEPlayerData d : FTBEPlayerData.MAP.values()) {
            d.sendTabName((ServerPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        FTBEPlayerData data = FTBEPlayerData.get(event.getPlayer());
        if (data == null) {
            return;
        }
        data.lastSeen = new TeleportPos((Entity)event.getPlayer());
        data.save();
    }

    @SubscribeEvent
    public static void playerLoad(PlayerEvent.LoadFromFile event) {
        FTBEPlayerData data;
        if (FTBEWorldData.instance != null && (data = FTBEPlayerData.get(event.getPlayer())) != null) {
            data.load();
        }
    }

    @SubscribeEvent
    public static void playerSaved(PlayerEvent.SaveToFile event) {
        FTBEPlayerData data;
        if (FTBEWorldData.instance != null && (data = FTBEPlayerData.get(event.getPlayer())) != null) {
            data.saveNow();
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player instanceof ServerPlayer) {
            FTBEPlayerData data = FTBEPlayerData.get(event.player);
            Abilities abilities = event.player.m_150110_();
            if (data == null) {
                return;
            }
            if (data.god && !abilities.f_35934_) {
                abilities.f_35934_ = true;
                event.player.m_6885_();
            }
            if (data.fly && !abilities.f_35936_) {
                abilities.f_35936_ = true;
                event.player.m_6885_();
            }
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            long now = System.currentTimeMillis();
            Iterator<TPACommands.TPARequest> iterator = TPACommands.REQUESTS.values().iterator();
            while (iterator.hasNext()) {
                TPACommands.TPARequest r = iterator.next();
                if (now <= r.created + 60000L) continue;
                ServerPlayer source = r.server.m_6846_().m_11259_(r.source.uuid);
                ServerPlayer target = r.server.m_6846_().m_11259_(r.target.uuid);
                if (source != null) {
                    source.m_6352_((Component)new TextComponent("TPA request expired!"), Util.f_137441_);
                }
                if (target != null) {
                    target.m_6352_((Component)new TextComponent("TPA request expired!"), Util.f_137441_);
                }
                iterator.remove();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerServerChatHighest(ServerChatEvent event) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)event.getPlayer());
        if (data != null && data.muted) {
            event.setCanceled(true);
            event.getPlayer().m_5661_((Component)new TextComponent("You can't use chat, you've been muted by an admin!").m_130940_(ChatFormatting.RED), false);
        }
    }

    @SubscribeEvent
    public static void playerName(PlayerEvent.NameFormat event) {
        FTBEPlayerData data;
        if (event.getPlayer() instanceof ServerPlayer && (data = FTBEPlayerData.get(event.getPlayer())) != null && !data.nick.isEmpty()) {
            event.setDisplayname((Component)new TextComponent(data.nick));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerNameLow(PlayerEvent.NameFormat event) {
        FTBEPlayerData data;
        if (event.getPlayer() instanceof ServerPlayer && (data = FTBEPlayerData.get(event.getPlayer())) != null && data.recording > 0) {
            event.setDisplayname((Component)new TextComponent("").m_7220_((Component)new TextComponent("\u23fa").m_130948_(data.recording == 1 ? RECORDING_STYLE : STREAMING_STYLE)).m_130946_(" ").m_7220_(event.getDisplayname()));
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            FTBEPlayerData.addTeleportHistory((ServerPlayer)event.getEntity());
        }
    }
}

