/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.model;

import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.model.CGBakedModel;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class CGConnectedBakedModel
extends CGBakedModel {
    public CGConnectedBakedModel(CGGlassBlock block) {
        super(block);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        ModelData modelData = new ModelData();
        for (Direction direction : Direction.values()) {
            modelData.sides.put(direction, new SideData(direction, (BlockGetter)world, pos, state.m_60734_()));
        }
        return modelData;
    }

    @Override
    protected float[] getUV(Direction side, IModelData modelData) {
        if (!(modelData instanceof ModelData)) {
            return this.getUV(0, 0);
        }
        SideData blocks = ((ModelData)modelData).sides.get(side);
        float[] uv = !(blocks.left || blocks.up || blocks.right || blocks.down) ? this.getUV(0, 0) : (blocks.left && !blocks.up && !blocks.right && !blocks.down ? this.getUV(3, 0) : (!blocks.left && blocks.up && !blocks.right && !blocks.down ? this.getUV(0, 3) : (!blocks.left && !blocks.up && blocks.right && !blocks.down ? this.getUV(1, 0) : (!blocks.left && !blocks.up && !blocks.right && blocks.down ? this.getUV(0, 1) : (blocks.left && !blocks.up && blocks.right && !blocks.down ? this.getUV(2, 0) : (!blocks.left && blocks.up && !blocks.right && blocks.down ? this.getUV(0, 2) : (blocks.left && blocks.up && !blocks.right && !blocks.down ? (blocks.up_left ? this.getUV(3, 3) : this.getUV(5, 1)) : (!blocks.left && blocks.up && blocks.right && !blocks.down ? (blocks.up_right ? this.getUV(1, 3) : this.getUV(4, 1)) : (!blocks.left && !blocks.up && blocks.right && blocks.down ? (blocks.down_right ? this.getUV(1, 1) : this.getUV(4, 0)) : (blocks.left && !blocks.up && !blocks.right && blocks.down ? (blocks.down_left ? this.getUV(3, 1) : this.getUV(5, 0)) : (!blocks.left ? (blocks.up_right && blocks.down_right ? this.getUV(1, 2) : (blocks.up_right ? this.getUV(4, 2) : (blocks.down_right ? this.getUV(6, 2) : this.getUV(6, 0)))) : (!blocks.up ? (blocks.down_left && blocks.down_right ? this.getUV(2, 1) : (blocks.down_left ? this.getUV(7, 2) : (blocks.down_right ? this.getUV(5, 2) : this.getUV(7, 0)))) : (!blocks.right ? (blocks.up_left && blocks.down_left ? this.getUV(3, 2) : (blocks.up_left ? this.getUV(7, 3) : (blocks.down_left ? this.getUV(5, 3) : this.getUV(7, 1)))) : (!blocks.down ? (blocks.up_left && blocks.up_right ? this.getUV(2, 3) : (blocks.up_left ? this.getUV(4, 3) : (blocks.up_right ? this.getUV(6, 3) : this.getUV(6, 1)))) : (blocks.up_left && blocks.up_right && blocks.down_left && blocks.down_right ? this.getUV(2, 2) : (!blocks.up_left && blocks.up_right && blocks.down_left && blocks.down_right ? this.getUV(7, 7) : (blocks.up_left && !blocks.up_right && blocks.down_left && blocks.down_right ? this.getUV(6, 7) : (blocks.up_left && blocks.up_right && !blocks.down_left && blocks.down_right ? this.getUV(7, 6) : (blocks.up_left && blocks.up_right && blocks.down_left && !blocks.down_right ? this.getUV(6, 6) : (!blocks.up_left && blocks.up_right && !blocks.down_right && blocks.down_left ? this.getUV(0, 4) : (blocks.up_left && !blocks.up_right && blocks.down_right && !blocks.down_left ? this.getUV(0, 5) : (!blocks.up_left && !blocks.up_right && blocks.down_right && blocks.down_left ? this.getUV(3, 6) : (blocks.up_left && !blocks.up_right && !blocks.down_right && blocks.down_left ? this.getUV(3, 7) : (blocks.up_left && blocks.up_right && !blocks.down_right && !blocks.down_left ? this.getUV(2, 7) : (!blocks.up_left && blocks.up_right && blocks.down_right && !blocks.down_left ? this.getUV(2, 6) : (blocks.up_left ? this.getUV(5, 7) : (blocks.up_right ? this.getUV(4, 7) : (blocks.down_right ? this.getUV(4, 6) : (blocks.down_left ? this.getUV(5, 6) : this.getUV(0, 6))))))))))))))))))))))))))))));
        return uv;
    }

    private float[] getUV(int x, int y) {
        return new float[]{x * 2, y * 2, (x + 1) * 2, (y + 1) * 2};
    }

    private static class ModelData
    implements IModelData {
        public Map<Direction, SideData> sides = new HashMap<Direction, SideData>();

        private ModelData() {
        }

        public boolean hasProperty(ModelProperty<?> prop) {
            return false;
        }

        @Nullable
        public <T> T getData(ModelProperty<T> prop) {
            return null;
        }

        @Nullable
        public <T> T setData(ModelProperty<T> prop, T data) {
            return null;
        }
    }

    private static class SideData {
        private BlockGetter world;
        private Block block;
        public boolean left;
        public boolean right;
        public boolean up;
        public boolean up_left;
        public boolean up_right;
        public boolean down;
        public boolean down_left;
        public boolean down_right;

        public SideData(Direction side, BlockGetter world, BlockPos pos, Block block) {
            Direction down;
            Direction up;
            Direction right;
            Direction left;
            this.world = world;
            this.block = block;
            if (side.m_122434_() == Direction.Axis.Y) {
                left = Direction.WEST;
                right = Direction.EAST;
                up = side == Direction.UP ? Direction.NORTH : Direction.SOUTH;
                down = side == Direction.UP ? Direction.SOUTH : Direction.NORTH;
            } else {
                left = side.m_122427_();
                right = side.m_122428_();
                up = Direction.UP;
                down = Direction.DOWN;
            }
            this.left = this.isSameBlock(pos.m_142300_(left));
            this.right = this.isSameBlock(pos.m_142300_(right));
            this.up = this.isSameBlock(pos.m_142300_(up));
            this.up_left = this.isSameBlock(pos.m_142300_(up).m_142300_(left));
            this.up_right = this.isSameBlock(pos.m_142300_(up).m_142300_(right));
            this.down = this.isSameBlock(pos.m_142300_(down));
            this.down_left = this.isSameBlock(pos.m_142300_(down).m_142300_(left));
            this.down_right = this.isSameBlock(pos.m_142300_(down).m_142300_(right));
        }

        private boolean isSameBlock(BlockPos pos) {
            return this.world.m_8055_(pos).m_60734_() == this.block;
        }
    }
}

