/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.lightoverlay;

import at.ridgo8.moreoverlays.api.lightoverlay.LightScannerBase;
import at.ridgo8.moreoverlays.config.Config;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class LightScannerVanilla
extends LightScannerBase {
    private static final AABB TEST_BB = new AABB(0.3, 0.0, 0.3, 0.7, 1.0, 0.7);
    private static boolean ChiselsAndBits = false;
    private static boolean ChiselsAndBitsCheckDone = false;
    private final List<EntityType<?>> typesToCheck = ForgeRegistries.ENTITIES.getValues().stream().filter(type -> type.m_20654_() && type.m_20674_() == MobCategory.MONSTER).collect(Collectors.toList());

    private static boolean checkCollision(BlockPos pos, Level world) {
        BlockState block1 = world.m_8055_(pos);
        if (block1.m_60838_((BlockGetter)world, pos) || !((Boolean)Config.light_IgnoreLayer.get()).booleanValue() && world.m_8055_(pos.m_7494_()).m_60838_((BlockGetter)world, pos.m_7494_())) {
            return false;
        }
        if (world.m_46859_(pos) && (((Boolean)Config.light_IgnoreLayer.get()).booleanValue() || world.m_46859_(pos.m_7494_()))) {
            return true;
        }
        AABB bb = TEST_BB.m_82386_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        ArrayList bbCollisions = Lists.newArrayList((Iterable)world.m_186434_(null, bb));
        if (bbCollisions.size() == 0 && !world.m_46855_(bb)) {
            if (((Boolean)Config.light_IgnoreLayer.get()).booleanValue()) {
                return true;
            }
            AABB bb2 = bb.m_82386_(0.0, 1.0, 0.0);
            ArrayList bb2Collisions = Lists.newArrayList((Iterable)world.m_186434_(null, bb2));
            return bb2Collisions.size() == 0 && !world.m_46855_(bb2);
        }
        return false;
    }

    private static boolean isChiselsAndBitsLoaded() {
        if (!ChiselsAndBitsCheckDone) {
            ChiselsAndBits = ModList.get().isLoaded("chiselsandbits");
            ChiselsAndBitsCheckDone = true;
        }
        return ChiselsAndBits;
    }

    @Override
    public byte getSpawnModeAt(BlockPos pos, Level world) {
        if (world.m_45517_(LightLayer.BLOCK, pos) >= (Integer)Config.light_SaveLevel.get()) {
            return 0;
        }
        BlockPos blockPos = pos.m_7495_();
        if (world.m_46859_(blockPos)) {
            return 0;
        }
        if (world.m_46855_(new AABB(blockPos))) {
            return 0;
        }
        if (LightScannerVanilla.isChiselsAndBitsLoaded() && world.m_8055_(blockPos).m_60734_().m_49954_().getString().contains("chiselsandbits")) {
            return 0;
        }
        if (!LightScannerVanilla.checkCollision(pos, world)) {
            return 0;
        }
        BlockState state = world.m_8055_(blockPos);
        Block block = state.m_60734_();
        if (!((Boolean)Config.light_SimpleEntityCheck.get()).booleanValue()) {
            boolean hasSpawnable = false;
            for (EntityType<?> type : this.typesToCheck) {
                if (!block.isValidSpawn(state, (BlockGetter)world, blockPos, SpawnPlacements.Type.ON_GROUND, type)) continue;
                hasSpawnable = true;
                break;
            }
            if (!hasSpawnable) {
                return 0;
            }
        } else if (!block.isValidSpawn(state, (BlockGetter)world, blockPos, SpawnPlacements.Type.ON_GROUND, EntityType.f_20501_)) {
            return 0;
        }
        if (world.m_45517_(LightLayer.SKY, pos) >= (Integer)Config.light_SaveLevel.get()) {
            return 1;
        }
        return 2;
    }
}

