/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.itemsearch;

import at.ridgo8.moreoverlays.MoreOverlays;
import at.ridgo8.moreoverlays.itemsearch.ItemUtils;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.gui.overlay.IngredientListOverlay;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@JeiPlugin
public class JeiModule
implements IModPlugin {
    public static IIngredientListOverlay overlay;
    public static IIngredientFilter filter;
    private static IJeiHelpers jeiHelpers;
    private static IngredientListOverlay overlayInternal;
    private static EditBox textField;

    public static void updateModule() {
        if (overlay instanceof IngredientListOverlay) {
            overlayInternal = (IngredientListOverlay)overlay;
            try {
                Field searchField = IngredientListOverlay.class.getDeclaredField("textFieldFilter");
                searchField.setAccessible(true);
                textField = (EditBox)searchField.get(overlayInternal);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                MoreOverlays.logger.error("Something went wrong. Tried to load JEI Search Text Field object");
                e.printStackTrace();
            }
        } else {
            overlayInternal = null;
            textField = null;
        }
    }

    public static EditBox getJEITextField() {
        return textField;
    }

    public static boolean areItemsEqualInterpreter(ItemStack stack1, ItemStack stack2) {
        if (jeiHelpers == null) {
            return ItemUtils.matchNBT(stack1, stack2);
        }
        return jeiHelpers.getStackHelper().isEquivalent(stack1, stack2, UidContext.Ingredient);
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        overlay = jeiRuntime.getIngredientListOverlay();
        filter = jeiRuntime.getIngredientFilter();
        JeiModule.updateModule();
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        jeiHelpers = registration.getJeiHelpers();
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("moreoverlays", "jei_module");
    }
}

