/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.gui;

import at.ridgo8.moreoverlays.gui.config.ConfigOptionList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigScreen
extends Screen {
    private final String modId;
    private final ForgeConfigSpec configSpec;
    private final List<String> pathCache = new ArrayList<String>();
    private final Screen modListScreen;
    private ConfigOptionList optionList;
    private String categoryTitle = null;
    private Button btnReset;
    private Button btnUndo;
    private Button btnBack;
    private String txtUndo = "";
    private String txtReset = "";
    private String txtDone = "";

    public ConfigScreen(Screen modListScreen, ForgeConfigSpec spec, String modId) {
        super((Component)new TranslatableComponent("gui.config." + modId + ".tile"));
        this.modListScreen = modListScreen;
        this.configSpec = spec;
        this.modId = modId;
        this.txtReset = I18n.m_118938_((String)"gui.config.moreoverlays.reset_config", (Object[])new Object[0]);
        this.txtUndo = I18n.m_118938_((String)"gui.config.moreoverlays.undo", (Object[])new Object[0]);
        this.txtDone = I18n.m_118938_((String)"gui.done", (Object[])new Object[0]);
    }

    protected void m_7856_() {
        int pad;
        if (this.optionList == null) {
            this.optionList = new ConfigOptionList(this.f_96541_, this.modId, this);
            if (this.pathCache.isEmpty()) {
                this.optionList.setConfiguration(this.configSpec);
            } else {
                this.optionList.setConfiguration(this.configSpec, this.pathCache);
            }
        }
        Font font = Minecraft.m_91087_().f_91062_;
        int undoGlyphWidth = font.m_92895_("\u21b6") * 2;
        int resetGlyphWidth = font.m_92895_("\u2604") * 2;
        int undoWidth = font.m_92895_(" " + this.txtUndo) + undoGlyphWidth + 20;
        int resetWidth = font.m_92895_(" " + this.txtReset) + resetGlyphWidth + 20;
        int doneWidth = Math.max(font.m_92895_(this.txtDone) + 20, 100);
        int buttonY = this.f_96544_ - 32 + 6;
        int buttonHeight = 20;
        int xBack = pad = 10;
        int xDefaultAll = this.f_96543_ - resetWidth - pad;
        int xUndoAll = xDefaultAll - undoWidth;
        this.btnReset = new Button(xDefaultAll, buttonY, 100, 20, Component.m_130674_((String)("\u2604 " + this.txtReset)), btn -> this.optionList.reset());
        this.btnUndo = new Button(xUndoAll, buttonY, 100, 20, Component.m_130674_((String)("\u21b6 " + this.txtUndo)), btn -> this.optionList.undo());
        this.btnBack = new Button(xBack, buttonY, doneWidth, 20, Component.m_130674_((String)(" " + this.txtDone)), btn -> this.back());
        this.m_7787_((GuiEventListener)this.optionList);
        this.m_7787_((GuiEventListener)this.btnReset);
        this.m_7787_((GuiEventListener)this.btnUndo);
        this.m_7787_((GuiEventListener)this.btnBack);
        this.btnReset.f_93623_ = false;
        this.btnUndo.f_93623_ = false;
        this.optionList.updateGui();
    }

    private void back() {
        this.save();
        if (!this.optionList.getCurrentPath().isEmpty()) {
            this.optionList.pop();
        } else {
            Minecraft.m_91087_().m_91152_(this.modListScreen);
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        this.optionList.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.btnReset.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.btnUndo.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.btnBack.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        ConfigScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
        if (this.categoryTitle != null) {
            ConfigScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.categoryTitle, (int)(this.f_96543_ / 2), (int)24, (int)0xFFFFFF);
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void save() {
        this.optionList.save();
        this.configSpec.save();
        this.optionList.undo();
    }

    public void m_96624_() {
        super.m_96624_();
        this.btnReset.f_93623_ = this.optionList.isResettable();
        this.btnUndo.f_93623_ = this.optionList.isUndoable();
    }

    public void updatePath(List<String> newPath) {
        String key = this.optionList.categoryTitleKey(newPath);
        this.categoryTitle = key == null ? null : I18n.m_118938_((String)key, (Object[])new Object[0]);
        this.pathCache.clear();
        this.pathCache.addAll(newPath);
    }

    public boolean m_7933_(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (key == 256) {
            this.back();
            return true;
        }
        return super.m_7933_(key, p_keyPressed_2_, p_keyPressed_3_);
    }
}

