/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2.stack;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.util.BlockApiCache;
import java.util.Map;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.ae2.stack.HandlerStrategy;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;

public class MekanismStackExportStrategy
implements StackExportStrategy {
    private final Map<Byte, BlockApiCache<? extends IChemicalHandler>> lookups;
    private final Direction fromSide;

    public MekanismStackExportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.lookups = Map.of((byte)0, BlockApiCache.create(MekCapabilities.GAS_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos), (byte)1, BlockApiCache.create(MekCapabilities.INFUSION_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos), (byte)2, BlockApiCache.create(MekCapabilities.PIGMENT_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos), (byte)3, BlockApiCache.create(MekCapabilities.SLURRY_HANDLER_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos));
        this.fromSide = fromSide;
    }

    public long transfer(StackTransferContext context, AEKey what, long amount, Actionable mode) {
        if (!(what instanceof MekanismKey)) {
            return 0L;
        }
        MekanismKey mekanismKey = (MekanismKey)what;
        for (Map.Entry<Byte, BlockApiCache<? extends IChemicalHandler>> entry : this.lookups.entrySet()) {
            IChemicalHandler storage;
            if (entry.getKey().byteValue() != mekanismKey.getForm() || (storage = (IChemicalHandler)entry.getValue().find(this.fromSide)) == null) continue;
            IStorageService inv = context.getInternalStorage();
            long extracted = StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)amount, (IActionSource)context.getActionSource(), (Actionable)Actionable.SIMULATE);
            long wasInserted = HandlerStrategy.insert(storage, what, extracted, mode);
            if (wasInserted > 0L) {
                if (mode == Actionable.MODULATE) {
                    StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)wasInserted, (IActionSource)context.getActionSource(), (Actionable)Actionable.MODULATE);
                }
                return wasInserted;
            }
            return 0L;
        }
        return 0L;
    }

    public long push(AEKey what, long amount, Actionable mode) {
        if (!(what instanceof MekanismKey)) {
            return 0L;
        }
        MekanismKey mekanismKey = (MekanismKey)what;
        for (Map.Entry<Byte, BlockApiCache<? extends IChemicalHandler>> entry : this.lookups.entrySet()) {
            IChemicalHandler storage;
            if (entry.getKey().byteValue() != mekanismKey.getForm() || (storage = (IChemicalHandler)entry.getValue().find(this.fromSide)) == null) continue;
            return HandlerStrategy.insert(storage, what, amount, mode);
        }
        return 0L;
    }
}

