/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.pylon;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import io.github.noeppi_noeppi.libx.render.ClientTickHandler;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.ModBlocks;
import mythicbotany.MythicBotany;
import mythicbotany.pylon.BlockAlfsteelPylon;
import mythicbotany.pylon.TileAlfsteelPylon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.model.ModModelLayers;
import vazkii.botania.client.model.ModelPylonNatura;
import vazkii.botania.mixin.client.AccessorRenderType;

public class RenderAlfsteelPylon
implements BlockEntityRenderer<TileAlfsteelPylon> {
    public static final ResourceLocation TEXTURE = MythicBotany.getInstance().resource("textures/model/pylon_alfsteel.png");
    public static final RenderType TARGET = RenderAlfsteelPylon.createRenderType(false);
    public static final RenderType DIRECT_TARGET = RenderAlfsteelPylon.createRenderType(true);
    private final ModelPylonNatura model;
    private ItemTransforms.TransformType forceTransform = ItemTransforms.TransformType.NONE;

    public RenderAlfsteelPylon(BlockEntityRendererProvider.Context ctx) {
        this.model = new ModelPylonNatura(ctx.m_173582_(ModModelLayers.PYLON_NATURA));
    }

    public void render(@Nonnull TileAlfsteelPylon blockEntity, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        this.doRender(blockEntity, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
    }

    public void doRender(@Nullable TileAlfsteelPylon pylon, float pticks, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        boolean direct = pylon == null && (this.forceTransform == ItemTransforms.TransformType.GUI || this.forceTransform.m_111841_());
        RenderType glow = direct ? DIRECT_TARGET : TARGET;
        poseStack.m_85836_();
        float worldTime = (float)ClientTickHandler.ticksInGame + pticks;
        worldTime += pylon == null ? 0.0f : (float)new Random(pylon.m_58899_().hashCode()).nextInt(360);
        poseStack.m_85837_(0.0, pylon == null ? 1.35 : 1.5, 0.0);
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, -0.5);
        if (pylon != null) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(worldTime * 1.5f));
        }
        RenderType layer = RenderType.m_110473_((ResourceLocation)TEXTURE);
        VertexConsumer vertex = buffer.m_6299_(layer);
        this.model.renderRing(poseStack, vertex, light, overlay);
        if (pylon != null) {
            poseStack.m_85837_(0.0, Math.sin((double)worldTime / 20.0) / 20.0 - 0.025, 0.0);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        if (pylon != null) {
            poseStack.m_85837_(0.0, Math.sin((double)worldTime / 20.0) / 17.5, 0.0);
        }
        poseStack.m_85837_(0.5, 0.0, -0.5);
        if (pylon != null) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-worldTime));
        }
        vertex = buffer.m_6299_(glow);
        this.model.renderCrystal(poseStack, vertex, light, overlay);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private static RenderType createRenderType(boolean direct) {
        RenderType.CompositeState.CompositeStateBuilder state = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(CoreShaders::pylon)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TEXTURE, false, false)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_);
        if (!direct) {
            state = state.m_110675_(RenderStateShard.f_110129_);
        }
        return AccessorRenderType.create((String)("mythicbotany_pylon" + (direct ? "_direct" : "")), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)128, (boolean)false, (boolean)false, (RenderType.CompositeState)state.m_110691_(false));
    }

    public static class ItemRenderer
    extends BlockEntityWithoutLevelRenderer {
        private static final LazyValue<TileAlfsteelPylon> DUMMY = new LazyValue(() -> new TileAlfsteelPylon(ModBlocks.alfsteelPylon.getBlockEntityType(), BlockPos.f_121853_, ModBlocks.alfsteelPylon.m_49966_()));

        public ItemRenderer() {
            super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        }

        public void m_108829_(ItemStack stack, @Nonnull ItemTransforms.TransformType type, @Nonnull PoseStack ms, @Nonnull MultiBufferSource buffer, int light, int overlay) {
            if (Block.m_49814_((Item)stack.m_41720_()) instanceof BlockAlfsteelPylon) {
                BlockEntityRenderer renderer = this.f_172547_.m_112265_((BlockEntity)((TileAlfsteelPylon)((Object)DUMMY.get())));
                ((RenderAlfsteelPylon)renderer).forceTransform = type;
                ((RenderAlfsteelPylon)renderer).doRender(null, 0.0f, ms, buffer, light, overlay);
            }
        }
    }
}

