/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.pylon;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import mythicbotany.pylon.PylonRepairable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.apache.commons.lang3.tuple.Pair;

public class PylonRepairables {
    public static final int PRIORITY_ITEM_WITH_INTERFACE = 10;
    public static final int PRIORITY_MENDING = -10;
    public static final int PRIORITY_DEFAULT = 0;
    private static final List<Pair<PylonRepairable, Integer>> repairables = new LinkedList<Pair<PylonRepairable, Integer>>();

    public static void register(PylonRepairable repairable) {
        PylonRepairables.register(repairable, 0);
    }

    public static void register(PylonRepairable repairable, int priority) {
        repairables.add((Pair<PylonRepairable, Integer>)Pair.of((Object)repairable, (Object)(-priority)));
        repairables.sort(Comparator.comparing(Pair::getRight));
    }

    @Nullable
    public static PylonRepairable getRepairInfo(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (Pair<PylonRepairable, Integer> entry : repairables) {
            if (!((PylonRepairable)entry.getLeft()).canRepairPylon(stack)) continue;
            return (PylonRepairable)entry.getLeft();
        }
        return null;
    }

    public static class MendingPylonRepairable
    implements PylonRepairable {
        public static final int MANA_PER_DURABILITY = 25;
        public static final int DURABILITY_PER_TICK = 5;

        @Override
        public int getRepairManaPerTick(ItemStack stack) {
            return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)stack) > 0 ? 125 : 0;
        }

        @Override
        public boolean canRepairPylon(ItemStack stack) {
            return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)stack) > 0 && stack.m_41773_() > 0;
        }

        @Override
        public ItemStack repairOneTick(ItemStack stack) {
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)stack) > 0 && stack.m_41773_() > 0) {
                stack.m_41721_(stack.m_41773_() - 5);
            }
            return stack;
        }
    }

    public static class ItemPylonRepairable
    implements PylonRepairable {
        @Override
        public int getRepairManaPerTick(ItemStack stack) {
            return stack.m_41720_() instanceof PylonRepairable ? ((PylonRepairable)stack.m_41720_()).getRepairManaPerTick(stack) : 0;
        }

        @Override
        public boolean canRepairPylon(ItemStack stack) {
            return stack.m_41720_() instanceof PylonRepairable && ((PylonRepairable)stack.m_41720_()).canRepairPylon(stack);
        }

        @Override
        public ItemStack repairOneTick(ItemStack stack) {
            return stack.m_41720_() instanceof PylonRepairable ? ((PylonRepairable)stack.m_41720_()).repairOneTick(stack) : stack;
        }
    }
}

