/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.network;

import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.network.NetworkX;
import mythicbotany.network.AlfSwordLeftClickHandler;
import mythicbotany.network.AlfSwordLeftClickSerializer;
import mythicbotany.network.InfusionHandler;
import mythicbotany.network.InfusionSerializer;
import mythicbotany.network.ItemMagnetImmunityHandler;
import mythicbotany.network.ItemMagnetImmunitySerializer;
import mythicbotany.network.ParticleHandler;
import mythicbotany.network.ParticleSerializer;
import mythicbotany.network.PylonHandler;
import mythicbotany.network.PylonSerializer;
import mythicbotany.network.UpdatePortalTimeHandler;
import mythicbotany.network.UpdatePortalTimeSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;

public class MythicNetwork
extends NetworkX {
    public MythicNetwork(ModX mod) {
        super(mod);
    }

    protected NetworkX.Protocol getProtocol() {
        return NetworkX.Protocol.of((String)"6");
    }

    public void registerPackets() {
        this.register(new ParticleSerializer(), () -> ParticleHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new InfusionSerializer(), () -> InfusionHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new PylonSerializer(), () -> PylonHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new UpdatePortalTimeSerializer(), () -> UpdatePortalTimeHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new ItemMagnetImmunitySerializer(), () -> ItemMagnetImmunityHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new AlfSwordLeftClickSerializer(), () -> AlfSwordLeftClickHandler::handle, NetworkDirection.PLAY_TO_SERVER);
    }

    public void spawnParticle(Level level, SimpleParticleType particle, int amount, double x, double y, double z, double xm, double ym, double zm, double xd, double yd, double zd) {
        this.spawnParticle(level, particle, amount, x, y, z, xm, ym, zm, xd, yd, zd, false);
    }

    public void spawnParticle(Level level, SimpleParticleType particle, int amount, double x, double y, double z, double xm, double ym, double zm, double xd, double yd, double zd, boolean randomizePosition) {
        if (level.f_46443_) {
            for (int i = 0; i < amount; ++i) {
                if (randomizePosition) {
                    level.m_7106_((ParticleOptions)particle, x + level.f_46441_.nextDouble() * 2.0 * xd - xd, y + level.f_46441_.nextDouble() * 2.0 * yd - yd, z + level.f_46441_.nextDouble() * 2.0 * zd - zd, xm, ym, zm);
                    continue;
                }
                level.m_7106_((ParticleOptions)particle, x, y, z, xm + level.f_46441_.nextDouble() * 2.0 * xd - xd, ym + level.f_46441_.nextDouble() * 2.0 * yd - yd, zm + level.f_46441_.nextDouble() * 2.0 * zd - zd);
            }
        } else {
            this.channel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, 100.0, level.m_46472_())), (Object)new ParticleSerializer.ParticleMessage(particle.getRegistryName(), level.m_46472_().getRegistryName(), x, y, z, amount, xm, ym, zm, xd, yd, zd, randomizePosition));
        }
    }

    public void spawnInfusionParticles(Level level, BlockPos pos, double progress, int fromColor, int toColor) {
        if (!level.f_46443_) {
            this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)new InfusionSerializer.InfusionMessage(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), level.m_46472_().getRegistryName(), progress, fromColor, toColor));
        }
    }

    public void updatePortalTime(ServerPlayer player, int portalTime) {
        if (!player.m_20193_().f_46443_) {
            this.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdatePortalTimeSerializer.UpdatePortalTimeMessage(portalTime));
        }
    }

    public void setItemMagnetImmune(ItemEntity ie) {
        if (!ie.f_19853_.f_46443_ && !ie.getPersistentData().m_128471_("PreventRemoteMovement")) {
            ie.getPersistentData().m_128379_("PreventRemoteMovement", true);
            this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> ie), (Object)new ItemMagnetImmunitySerializer.ItemMagnetImmunityMessage(ie.m_142049_(), true, ie.m_20185_(), ie.m_20186_(), ie.m_20189_()));
        }
    }

    public void removeItemMagnetImmune(ItemEntity ie) {
        if (!ie.f_19853_.f_46443_ && ie.getPersistentData().m_128471_("PreventRemoteMovement")) {
            ie.getPersistentData().m_128379_("PreventRemoteMovement", false);
            this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> ie), (Object)new ItemMagnetImmunitySerializer.ItemMagnetImmunityMessage(ie.m_142049_(), false, ie.m_20185_(), ie.m_20186_(), ie.m_20189_()));
        }
    }
}

