/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.kvasir;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import io.github.noeppi_noeppi.libx.crafting.ingredient.NbtIngredient;
import io.github.noeppi_noeppi.libx.util.Misc;
import java.util.List;
import java.util.UUID;
import mythicbotany.MythicBotany;
import mythicbotany.rune.RuneRitualRecipe;
import mythicbotany.rune.SpecialRuneInput;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WanderingTraderRuneInput
extends SpecialRuneInput {
    public static final WanderingTraderRuneInput INSTANCE = new WanderingTraderRuneInput();
    private final ItemStack traderStack = new ItemStack((ItemLike)Items.f_42680_);

    private WanderingTraderRuneInput() {
        super(MythicBotany.getInstance().resource("wandering_trader"));
        CompoundTag nbt = this.traderStack.m_41784_();
        CompoundTag skullOwner = new CompoundTag();
        skullOwner.m_128362_("Id", UUID.fromString("3358ddae-3a41-4ba0-bdfa-ee54b6c55cf5"));
        CompoundTag properties = new CompoundTag();
        ListTag textures = new ListTag();
        CompoundTag texture = new CompoundTag();
        texture.m_128359_("Value", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWYxMzc5YTgyMjkwZDdhYmUxZWZhYWJiYzcwNzEwZmYyZWMwMmRkMzRhZGUzODZiYzAwYzkzMGM0NjFjZjkzMiJ9fX0=");
        textures.add((Object)texture);
        properties.m_128365_("textures", (Tag)textures);
        skullOwner.m_128365_("Properties", (Tag)properties);
        nbt.m_128365_("SkullOwner", (Tag)skullOwner);
        CompoundTag display = new CompoundTag();
        ListTag tooltipNBT = new ListTag();
        tooltipNBT.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TranslatableComponent("tooltip.mythicbotany.sacrifice_entity1").m_130940_(ChatFormatting.RESET).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(false))).m_130940_(ChatFormatting.AQUA))));
        tooltipNBT.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TranslatableComponent("tooltip.mythicbotany.sacrifice_entity2").m_130940_(ChatFormatting.RESET).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(false))).m_130940_(ChatFormatting.AQUA))));
        display.m_128365_("Lore", (Tag)tooltipNBT);
        nbt.m_128365_("display", (Tag)display);
        this.traderStack.m_41714_((Component)new TranslatableComponent("entity.minecraft.wandering_trader").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(false))).m_130940_(ChatFormatting.DARK_AQUA));
    }

    @Override
    public Either<MutableComponent, CompoundTag> apply(Level level, BlockPos pos, RuneRitualRecipe recipe) {
        Vec3 center = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        AABB aabb = new AABB(center, center).m_82400_(3.0);
        List traders = level.m_142425_((EntityTypeTest)EntityType.f_20494_, aabb, e -> true);
        if (traders.isEmpty()) {
            return Either.left((Object)new TranslatableComponent("message.mythicbotany.ritual_no_trader"));
        }
        WanderingTrader trader = (WanderingTrader)traders.get(0);
        if (trader.m_20202_() != null) {
            trader.m_8127_();
        }
        if (trader.m_20160_()) {
            trader.m_20153_();
        }
        CompoundTag traderData = trader.m_20240_(new CompoundTag());
        trader.f_21355_ = Misc.MISSIGNO;
        trader.m_6074_();
        return Either.right((Object)traderData);
    }

    @Override
    public void cancel(Level level, BlockPos pos, RuneRitualRecipe recipe, CompoundTag nbt) {
        WanderingTrader trader = new WanderingTrader(EntityType.f_20494_, level);
        UUID uid = trader.m_142081_();
        trader.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.3, (double)pos.m_123343_() + 0.5);
        trader.m_20258_(nbt);
        trader.m_20084_(uid);
        level.m_7967_((Entity)trader);
    }

    @Override
    public List<Ingredient> getJeiInputItems() {
        return ImmutableList.of((Object)new NbtIngredient(this.traderStack));
    }
}

