/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.jei;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mythicbotany.ModBlocks;
import mythicbotany.ModRecipes;
import mythicbotany.MythicBotany;
import mythicbotany.jei.InfusionCategory;
import mythicbotany.jei.LittleBoxItemRenderer;
import mythicbotany.jei.RuneRitualCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class MythicJei
implements IModPlugin {
    private static IJeiRuntime runtime = null;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return MythicBotany.getInstance().resource("jeiplugin");
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new InfusionCategory(registration.getJeiHelpers().getGuiHelper()), new RuneRitualCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RecipeManager recipes = Objects.requireNonNull(level).m_7465_();
        registration.addRecipes((Collection)recipes.m_44013_(ModRecipes.INFUSER), InfusionCategory.UID);
        registration.addRecipes((Collection)recipes.m_44013_(ModRecipes.RUNE_RITUAL), RuneRitualCategory.UID);
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.manaInfuser), new ResourceLocation[]{InfusionCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.centralRuneHolder), new ResourceLocation[]{RuneRitualCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.runeHolder), new ResourceLocation[]{RuneRitualCategory.UID});
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
        LittleBoxItemRenderer.setParent((IIngredientRenderer<ItemStack>)runtime.getIngredientManager().getIngredientRenderer((Object)new ItemStack((ItemLike)Items.f_42594_)));
    }

    public static void runtime(Consumer<IJeiRuntime> action) {
        if (runtime != null) {
            action.accept(runtime);
        }
    }

    public static <T> Optional<T> runtime(Function<IJeiRuntime, T> action) {
        if (runtime != null) {
            return Optional.of(action.apply(runtime));
        }
        return Optional.empty();
    }
}

