/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mythicbotany.ModBlocks;
import mythicbotany.MythicBotany;
import mythicbotany.infuser.IInfuserRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec2;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.TerraPlateDrawable;

public class InfusionCategory
implements IRecipeCategory<IInfuserRecipe> {
    public static final ResourceLocation UID = MythicBotany.getInstance().resource("jei_category_infusion");
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final IDrawable infuserPlate;

    public InfusionCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(114, 141);
        this.localizedName = new TranslatableComponent("block.mythicbotany.mana_infuser");
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/terrasteel_jei_overlay.png"), 42, 29, 64, 64);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack(ModBlocks.manaInfuser));
        IDrawable shimmerrock = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)vazkii.botania.common.block.ModBlocks.shimmerrock));
        this.infuserPlate = new TerraPlateDrawable(shimmerrock, shimmerrock, guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Blocks.f_50074_)));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends IInfuserRecipe> getRecipeClass() {
        return IInfuserRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull IInfuserRecipe recipe, @Nonnull IIngredients ii) {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        for (Ingredient ingredient : recipe.m_7527_()) {
            list.add(Arrays.asList(ingredient.m_43908_()));
        }
        ii.setInputLists(VanillaTypes.ITEM, list);
        ii.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(@Nonnull IRecipeLayout layout, @Nonnull IInfuserRecipe recipe, @Nonnull IIngredients ii) {
        layout.getItemStacks().init(0, false, 48, 37);
        layout.getItemStacks().set(0, (List)ii.getOutputs(VanillaTypes.ITEM).get(0));
        double angle = 360.0 / (double)ii.getInputs(VanillaTypes.ITEM).size();
        Vec2 point = new Vec2(48.0f, 5.0f);
        Vec2 center = new Vec2(48.0f, 37.0f);
        for (int i = 1; i <= ii.getInputs(VanillaTypes.ITEM).size(); ++i) {
            layout.getItemStacks().init(i, true, Math.round(point.f_82470_), Math.round(point.f_82471_));
            layout.getItemStacks().set(i, (List)ii.getInputs(VanillaTypes.ITEM).get(i - 1));
            point = PetalApothecaryRecipeCategory.rotatePointAbout((Vec2)point, (Vec2)center, (double)angle);
        }
        layout.getItemStacks().init(ii.getInputs(VanillaTypes.ITEM).size() + 1, true, 48, 92);
        layout.getItemStacks().set(ii.getInputs(VanillaTypes.ITEM).size() + 1, new ItemStack(ModBlocks.manaInfuser));
    }

    public void draw(IInfuserRecipe recipe, @Nonnull PoseStack poseStack, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(poseStack, 25, 14);
        HUDHandler.renderManaBar((PoseStack)poseStack, (int)6, (int)126, (int)255, (float)0.75f, (int)recipe.getManaUsage(), (int)4000000);
        this.infuserPlate.draw(poseStack, 35, 92);
        RenderSystem.m_69461_();
        MutableComponent manaAmount = new TextComponent(BigDecimal.valueOf((double)recipe.getManaUsage() / 1000000.0).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString()).m_130940_(ChatFormatting.BLUE);
        TranslatableComponent tc = new TranslatableComponent("tooltip.mythicbotany.cost_pools", new Object[]{manaAmount});
        Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)tc, (float)(57 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)tc) / 2), 133.0f, 0);
    }
}

