/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.infuser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.ModRecipes;
import mythicbotany.infuser.IInfuserRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class InfuserRecipe
implements IInfuserRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> inputs;
    private final int mana;
    private final int fromColor;
    private final int toColor;

    public InfuserRecipe(ResourceLocation id, ItemStack output, int mana, int fromColor, int toColor, Ingredient ... inputs) {
        this.id = id;
        this.output = output;
        this.mana = mana;
        this.fromColor = fromColor;
        this.toColor = toColor;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])inputs);
    }

    @Override
    public int getManaUsage() {
        return this.mana;
    }

    @Override
    public int fromColor() {
        return this.fromColor;
    }

    @Override
    public int toColor() {
        return this.toColor;
    }

    public boolean m_5818_(@Nonnull Container inv, @Nonnull Level level) {
        ArrayList<Ingredient> ingredientsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        IntStream.range(0, inv.m_6643_()).boxed().map(arg_0 -> ((Container)inv).m_8020_(arg_0)).filter(stack -> !stack.m_41619_()).forEach(stack -> ingredientsMissing.stream().filter(ingredient -> ingredient.test(stack)).findFirst().ifPresent(ingredientsMissing::remove));
        return ingredientsMissing.isEmpty();
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.output;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.INFUSER_SERIALIZER;
    }

    @Override
    public ItemStack result(List<ItemStack> inputs) {
        if (inputs.size() != this.inputs.size()) {
            return ItemStack.f_41583_;
        }
        block0: for (Ingredient item : this.inputs) {
            for (ItemStack stack : inputs) {
                if (!item.test(stack)) continue;
                continue block0;
            }
            return ItemStack.f_41583_;
        }
        return this.output.m_41777_();
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    @Nullable
    public static Pair<IInfuserRecipe, ItemStack> getOutput(Level level, List<ItemStack> inputs) {
        if (!inputs.isEmpty()) {
            if (inputs.stream().anyMatch(stack -> stack.m_41613_() != 1)) {
                return null;
            }
            for (Recipe recipe : level.m_7465_().m_44054_(ModRecipes.INFUSER).values()) {
                ItemStack stack2;
                if (!(recipe instanceof IInfuserRecipe) || (stack2 = ((IInfuserRecipe)recipe).result(inputs)).m_41619_()) continue;
                return Pair.of((Object)((IInfuserRecipe)recipe), (Object)stack2.m_41777_());
            }
        }
        return null;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<InfuserRecipe> {
        @Nonnull
        public InfuserRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"), (boolean)true);
            int mana = GsonHelper.m_13927_((JsonObject)json, (String)"mana");
            int fromColor = GsonHelper.m_13927_((JsonObject)json, (String)"fromColor");
            int toColor = GsonHelper.m_13927_((JsonObject)json, (String)"toColor");
            JsonArray ingrs = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.m_43917_((JsonElement)e));
            }
            return new InfuserRecipe(recipeId, output, mana, fromColor, toColor, inputs.toArray(new Ingredient[0]));
        }

        @Nullable
        public InfuserRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            Ingredient[] inputs = new Ingredient[buffer.readInt()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            }
            ItemStack output = buffer.m_130267_();
            int mana = buffer.readInt();
            int fromColor = buffer.readInt();
            int toColor = buffer.readInt();
            return new InfuserRecipe(recipeId, output, mana, fromColor, toColor, inputs);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull InfuserRecipe recipe) {
            buffer.writeInt(recipe.m_7527_().size());
            for (Ingredient input : recipe.m_7527_()) {
                input.m_43923_(buffer);
            }
            buffer.writeItemStack(recipe.m_8043_(), false);
            buffer.writeInt(recipe.getManaUsage());
            buffer.writeInt(recipe.fromColor);
            buffer.writeInt(recipe.toColor);
        }
    }
}

