/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.functionalflora.base;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.base.tile.BlockEntityBase;
import io.github.noeppi_noeppi.libx.base.tile.TickableBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.functionalflora.base.BlockFloatingFunctionalFlower;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.IWandBindable;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.subtile.RadiusDescriptor;

@OnlyIn(value=Dist.CLIENT, _interface=IWandHUD.class)
public abstract class FunctionalFlowerBase
extends BlockEntityBase
implements TickableBlock,
IWandBindable,
IWandable,
IWandHUD {
    public static final ResourceLocation POOL_ID = new ResourceLocation("botania", "mana_pool");
    public static final ResourceLocation SPREADER_ID = new ResourceLocation("botania", "mana_spreader");
    public static final int DEFAULT_MAX_MANA = 300;
    public static final int DEFAULT_MAX_TRANSFER = 30;
    public final int maxMana;
    public final int maxTransfer;
    public final int color;
    public final boolean isGenerating;
    @Nullable
    private BlockPos pool = null;
    @Nullable
    private IManaPool poolTile = null;
    @Nullable
    private IManaCollector spreaderTile = null;
    protected int mana = 0;
    private boolean floating = false;
    private transient int sizeLastCheck = -1;
    protected transient int redstoneIn = 0;
    protected transient boolean didWork;

    public FunctionalFlowerBase(BlockEntityType<?> type, BlockPos pos, BlockState state, int color, boolean isGenerating) {
        super(type, pos, state);
        this.color = color;
        this.maxMana = 300;
        this.maxTransfer = isGenerating ? 30 : Integer.MAX_VALUE;
        this.isGenerating = isGenerating;
    }

    public FunctionalFlowerBase(BlockEntityType<?> type, BlockPos pos, BlockState state, int color, int maxMana, int maxTransfer, boolean isGenerating) {
        super(type, pos, state);
        this.color = color;
        this.maxMana = maxMana;
        this.maxTransfer = maxTransfer;
        this.isGenerating = isGenerating;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == BotaniaForgeCapabilities.WANDABLE) {
            return LazyOptional.of(() -> this).cast();
        }
        return (LazyOptional)DistExecutor.unsafeRunForDist(() -> () -> cap == BotaniaForgeClientCapabilities.WAND_HUD ? LazyOptional.of(() -> this).cast() : super.getCapability(cap, side), () -> () -> super.getCapability(cap, side));
    }

    public final void tick() {
        boolean prevFloating = this.floating;
        this.floating = this.m_58900_().m_60734_() instanceof BlockFloatingFunctionalFlower;
        if (prevFloating != this.floating) {
            this.m_6596_();
        }
        this.linkPool();
        if (!this.f_58857_.f_46443_) {
            if (this.isGenerating) {
                if (this.spreaderTile != null && this.mana > 0) {
                    manaTransfer = Math.min(this.maxTransfer, Math.min(this.mana, this.spreaderTile.getMaxMana() - this.spreaderTile.getCurrentMana()));
                    this.spreaderTile.receiveMana(manaTransfer);
                    this.mana = Mth.m_14045_((int)(this.mana - manaTransfer), (int)0, (int)this.maxMana);
                    this.m_6596_();
                    this.markPoolDirty();
                }
            } else if (this.poolTile != null && this.mana < this.maxMana) {
                manaTransfer = Math.min(this.maxTransfer, Math.min(this.maxMana - this.mana, this.poolTile.getCurrentMana()));
                this.poolTile.receiveMana(-manaTransfer);
                this.mana = Mth.m_14045_((int)(this.mana + manaTransfer), (int)0, (int)this.maxMana);
                this.m_6596_();
                this.markPoolDirty();
            }
            this.redstoneIn = 0;
            for (Direction dir : Direction.values()) {
                int redstonePower = this.f_58857_.m_46681_(this.m_58899_().m_142300_(dir), dir);
                this.redstoneIn = Math.max(redstonePower, this.redstoneIn);
            }
        }
        double particleChance = 1.0 - (double)this.mana / (double)this.maxMana / 3.5;
        this.didWork = false;
        this.tickFlower();
        if (this.f_58857_.f_46443_) {
            if (this.didWork) {
                particleChance = 3.0 * particleChance;
            }
            float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
            float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(this.color & 0xFF) / 255.0f;
            if (Math.random() > particleChance) {
                BotaniaAPI.instance().sparkleFX(this.m_58904_(), (double)this.m_58899_().m_123341_() + 0.3 + Math.random() * 0.5, (double)this.m_58899_().m_123342_() + 0.5 + Math.random() * 0.5, (double)this.m_58899_().m_123343_() + 0.3 + Math.random() * 0.5, red, green, blue, (float)Math.random(), 5);
            }
        }
    }

    protected abstract void tickFlower();

    public boolean canSelect(Player player, ItemStack stack, BlockPos pos, Direction direction) {
        return true;
    }

    public boolean bindTo(Player player, ItemStack stack, BlockPos pos, Direction direction) {
        int range = 10;
        double dist = pos.m_123331_((Vec3i)this.m_58899_());
        if ((double)(range *= range) >= dist) {
            BlockEntity tile = player.f_19853_.m_7702_(pos);
            if (this.isGenerating && tile instanceof IManaCollector) {
                this.pool = tile.m_58899_();
                this.spreaderTile = (IManaCollector)tile;
                this.poolTile = null;
                this.m_6596_();
                return true;
            }
            if (!this.isGenerating && tile instanceof IManaPool) {
                this.pool = tile.m_58899_();
                this.poolTile = (IManaPool)tile;
                this.spreaderTile = null;
                this.m_6596_();
                return true;
            }
        }
        return false;
    }

    @Nullable
    public BlockPos getBinding() {
        return this.pool;
    }

    public void linkPool() {
        IManaCollector theTileObj = this.isGenerating ? this.spreaderTile : this.poolTile;
        BlockEntity theTile = !(theTileObj instanceof BlockEntity) ? null : (BlockEntity)theTileObj;
        if (this.pool != null && theTile == null || this.pool != null && !this.pool.equals((Object)theTile.m_58899_()) || this.pool != null && this.f_58857_.m_7702_(this.pool) != theTile) {
            BlockEntity te = this.f_58857_.m_7702_(this.pool);
            if (this.isGenerating) {
                this.poolTile = null;
                this.spreaderTile = !(te instanceof IManaCollector) ? null : (IManaCollector)te;
            } else {
                this.poolTile = !(te instanceof IManaPool) ? null : (IManaPool)te;
                this.spreaderTile = null;
            }
        }
        if (this.pool == null) {
            if (this.isGenerating) {
                network = BotaniaAPI.instance().getManaNetworkInstance();
                int size = network.getAllCollectorsInWorld(this.m_58904_()).size();
                if (size != this.sizeLastCheck) {
                    IManaCollector te = network.getClosestCollector(this.m_58899_(), this.m_58904_(), 10);
                    if (te != null) {
                        this.pool = te.getManaReceiverPos();
                        this.poolTile = null;
                        this.spreaderTile = te;
                        this.m_6596_();
                    }
                    this.sizeLastCheck = size;
                }
            } else {
                network = BotaniaAPI.instance().getManaNetworkInstance();
                int size = network.getAllPoolsInWorld(this.m_58904_()).size();
                if (size != this.sizeLastCheck) {
                    IManaPool te = network.getClosestPool(this.m_58899_(), this.m_58904_(), 10);
                    if (te != null) {
                        this.pool = te.getManaReceiverPos();
                        this.poolTile = te;
                        this.spreaderTile = null;
                        this.m_6596_();
                    }
                    this.sizeLastCheck = size;
                }
            }
        }
        this.m_6596_();
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.mana = nbt.m_128425_("mana", 3) ? Mth.m_14045_((int)nbt.m_128451_("mana"), (int)0, (int)this.maxMana) : 0;
        if (nbt.m_128441_("pool")) {
            CompoundTag poolTag = nbt.m_128469_("pool");
            this.pool = new BlockPos(poolTag.m_128451_("x"), poolTag.m_128451_("y"), poolTag.m_128451_("z"));
        } else {
            this.pool = null;
        }
        this.floating = nbt.m_128471_("floating");
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("mana", Mth.m_14045_((int)this.mana, (int)0, (int)this.maxMana));
        if (this.pool != null) {
            CompoundTag poolTag = new CompoundTag();
            poolTag.m_128405_("x", this.pool.m_123341_());
            poolTag.m_128405_("y", this.pool.m_123342_());
            poolTag.m_128405_("z", this.pool.m_123343_());
            compound.m_128365_("pool", (Tag)poolTag);
        }
        compound.m_128379_("floating", this.floating);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (!this.f_58857_.f_46443_) {
            tag.m_128405_("mana", Mth.m_14045_((int)this.mana, (int)0, (int)this.maxMana));
            if (this.pool != null) {
                CompoundTag poolTag = new CompoundTag();
                poolTag.m_128405_("x", this.pool.m_123341_());
                poolTag.m_128405_("y", this.pool.m_123342_());
                poolTag.m_128405_("z", this.pool.m_123343_());
                tag.m_128365_("pool", (Tag)poolTag);
            }
            tag.m_128379_("floating", this.floating);
        }
        return tag;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        if (this.f_58857_.f_46443_) {
            this.mana = Mth.m_14045_((int)nbt.m_128451_("mana"), (int)0, (int)this.maxMana);
            if (nbt.m_128441_("pool")) {
                CompoundTag poolTag = nbt.m_128469_("pool");
                this.pool = new BlockPos(poolTag.m_128451_("x"), poolTag.m_128451_("y"), poolTag.m_128451_("z"));
            } else {
                this.pool = null;
            }
            this.floating = nbt.m_128471_("floating");
        }
    }

    public boolean isValidBinding() {
        IManaCollector theTileObj;
        Object object = theTileObj = this.isGenerating ? this.spreaderTile : this.poolTile;
        if (!(theTileObj instanceof BlockEntity)) {
            return false;
        }
        BlockEntity theTile = (BlockEntity)theTileObj;
        return this.pool != null && theTile != null && theTile.m_58898_() && !theTile.m_58901_() && this.f_58857_.m_46805_(theTile.m_58899_()) && this.m_58904_().m_7702_(this.pool) == theTile;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloating(boolean floating) {
        this.floating = floating;
        this.m_6596_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public RadiusDescriptor getRadius() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RadiusDescriptor getSecondaryRadius() {
        return null;
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            LibX.getNetwork().requestBE(this.f_58857_, this.f_58858_);
        }
        return true;
    }

    public void renderHUD(PoseStack poseStack, Minecraft minecraft) {
        if (this.f_58857_ == null) {
            return;
        }
        String name = I18n.m_118938_((String)this.f_58856_.m_60734_().m_7705_(), (Object[])new Object[0]);
        BotaniaAPIClient.instance().drawComplexManaHUD(poseStack, this.color, this.getCurrentMana(), this.maxMana, name, new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(this.isGenerating ? SPREADER_ID : POOL_ID)), this.isValidBinding());
    }

    private void markPoolDirty() {
        if (this.poolTile instanceof BlockEntity) {
            ((BlockEntity)this.poolTile).m_6596_();
        }
        if (this.spreaderTile instanceof BlockEntity) {
            ((BlockEntity)this.spreaderTile).m_6596_();
        }
    }
}

