/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.functionalflora.base;

import com.google.common.collect.ImmutableMap;
import io.github.noeppi_noeppi.libx.base.tile.BlockBE;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.functionalflora.base.BlockFloatingFunctionalFlower;
import mythicbotany.functionalflora.base.FunctionalFlowerBase;
import mythicbotany.functionalflora.base.RenderFunctionalFlower;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import vazkii.botania.common.block.ModBlocks;

public class BlockFunctionalFlower<T extends FunctionalFlowerBase>
extends BlockBE<T>
implements IPlantable {
    private static final VoxelShape SHAPE = BlockFunctionalFlower.m_49796_((double)4.8, (double)0.0, (double)4.8, (double)12.8, (double)16.0, (double)12.8);
    private final BlockFloatingFunctionalFlower<T> floatingBlock;
    public final boolean isGenerating;

    public BlockFunctionalFlower(ModX mod, Class<T> beClass, BlockBehaviour.Properties properties, boolean isGenerating) {
        this(mod, beClass, properties, new Item.Properties(), isGenerating);
    }

    public BlockFunctionalFlower(ModX mod, Class<T> beClass, BlockBehaviour.Properties properties, Item.Properties itemProperties, boolean isGenerating) {
        super(mod, beClass, properties.m_60910_().m_60924_((state, world, pos) -> false).m_60966_().m_60918_(SoundType.f_56740_), itemProperties);
        this.isGenerating = isGenerating;
        this.floatingBlock = new BlockFloatingFunctionalFlower<T>(mod, beClass, this);
    }

    public Map<String, Object> getNamedAdditionalRegisters(ResourceLocation id) {
        return ImmutableMap.of((Object)"floating", this.floatingBlock);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(ResourceLocation id, Consumer<Runnable> defer) {
        BlockEntityRenderers.m_173590_((BlockEntityType)this.getBlockEntityType(), mgr -> new RenderFunctionalFlower());
        ItemBlockRenderTypes.setRenderLayer((Block)this, (RenderType)RenderType.m_110457_());
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6782_(@Nonnull BlockState blockState, @Nonnull Level level, @Nonnull BlockPos pos) {
        FunctionalFlowerBase te = (FunctionalFlowerBase)this.getBlockEntity(level, pos);
        if (te.getCurrentMana() > 0) {
            return 1 + (int)((double)te.getCurrentMana() / (double)te.maxMana * 14.0);
        }
        return 0;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Vec3 shift = state.m_60824_(level, pos);
        return SHAPE.m_83216_(shift.f_82479_, shift.f_82480_, shift.f_82481_);
    }

    @Nonnull
    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        return !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    protected boolean isValidGround(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_50546_) || state.m_60713_(Blocks.f_50599_) || state.m_60713_(Blocks.f_50093_) || state.m_60713_(ModBlocks.enchantedSoil) || state.m_60713_(Blocks.f_50195_) || state.canSustainPlant(level, pos, Direction.UP, (IPlantable)this);
    }

    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return this.isValidGround(level.m_8055_(blockpos), (BlockGetter)level, blockpos);
    }

    public boolean m_7420_(BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return type == PathComputationType.AIR && !this.f_60443_ || super.m_7357_(state, level, pos, type);
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        if (this.isGenerating) {
            tooltip.add((Component)new TranslatableComponent("botania.flowerType.generating").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)new TranslatableComponent("botania.flowerType.functional").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        tooltip.add((Component)new TranslatableComponent("block." + this.mod.modid + "." + this.getRegistryName().m_135815_() + ".description").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    public BlockFloatingFunctionalFlower<T> getFloatingBlock() {
        return this.floatingBlock;
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() != this) {
            return this.m_49966_();
        }
        return state;
    }
}

